/*
 * Decompiled with CFR 0.152.
 */
package com.corejsf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.tool.postem.PostemTool;

public class UploadRenderer
extends Renderer {
    public static final String PROPERTY_FILE_SIZE_MAX = "postem.upload.max";
    public static final int FILE_SIZE_MAX_DEFAULT = 1;

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        writer.startElement("input", component);
        writer.writeAttribute("type", (Object)"file", "type");
        writer.writeAttribute("name", (Object)clientId, "clientId");
        writer.endElement("input");
        writer.flush();
    }

    public void decode(FacesContext context, UIComponent component) {
        Object target;
        int maxFileSizeInMB;
        ExternalContext external = context.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)external.getRequest();
        String clientId = component.getClientId(context);
        FileItem item = (FileItem)request.getAttribute(clientId);
        try {
            maxFileSizeInMB = ServerConfigurationService.getInt((String)PROPERTY_FILE_SIZE_MAX, (int)1);
        }
        catch (NumberFormatException nfe) {
            maxFileSizeInMB = 1;
        }
        long maxFileSizeInBytes = 0x100000L * (long)maxFileSizeInMB;
        ValueBinding binding = component.getValueBinding("value");
        if (binding != null) {
            Object newValue;
            if (item.getSize() == 0L && item.getName().equals("")) {
                PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"missing_csv", (Object[])new Object[0]);
                newValue = "";
            } else if (item != null && item.getSize() > maxFileSizeInBytes) {
                PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"upload_file_size_error", (Object[])new Object[]{maxFileSizeInMB});
                newValue = "";
            } else if (item != null && item.getName().endsWith(".csv")) {
                if (binding.getType(context) == byte[].class) {
                    newValue = item.get();
                }
                if (binding.getType(context) == InputStream.class) {
                    try {
                        newValue = item.getInputStream();
                    }
                    catch (IOException ex) {
                        throw new FacesException((Throwable)ex);
                    }
                } else {
                    String encoding = request.getCharacterEncoding();
                    if (encoding != null) {
                        try {
                            newValue = item.getString(encoding);
                        }
                        catch (UnsupportedEncodingException ex) {
                            newValue = item.getString();
                        }
                    } else {
                        newValue = item.getString();
                    }
                }
                if (newValue.equals("")) {
                    PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"missing_csv", (Object[])new Object[0]);
                    newValue = "";
                }
            } else if (item != null && !item.getName().endsWith(".csv")) {
                PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"invalid_ext", (Object[])new Object[]{item.getName()});
                newValue = "";
            } else {
                newValue = "";
            }
            ((EditableValueHolder)component).setSubmittedValue(newValue);
        }
        if ((target = (binding = component.getValueBinding("target")) != null ? binding.getValue(context) : component.getAttributes().get("target")) != null) {
            File file;
            if (target instanceof File) {
                file = (File)target;
            } else {
                ServletContext servletContext = (ServletContext)external.getContext();
                file = new File(servletContext.getRealPath("/"), target.toString());
            }
            try {
                item.write(file);
            }
            catch (Exception ex) {
                throw new FacesException((Throwable)ex);
            }
        }
    }
}

