/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.postem;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.DataFormatException;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.apache.myfaces.shared_impl.util.MessageUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CSV {
    private List contents;
    private List headers;
    private List students;
    private String csv;
    private static boolean truncatingWarningDisplayed;
    public static final char COMMA_DELIM = ',';
    public static final char TAB_DELIM = '\t';
    public static final int MAX_COL_LENGTH = 2000;

    public CSV(String csv, boolean withHeader) throws DataFormatException {
        truncatingWarningDisplayed = false;
        this.contents = CSV.retrieveContents((String)csv, (char)',');
        this.headers = CSV.retrieveHeaders((List)this.contents);
        this.students = CSV.retrieveStudents((List)this.contents, (boolean)withHeader);
        this.csv = csv;
    }

    public CSV(String csv, boolean withHeader, char delimiter) throws DataFormatException {
        truncatingWarningDisplayed = false;
        this.contents = CSV.retrieveContents((String)csv, (char)delimiter);
        this.headers = CSV.retrieveHeaders((List)this.contents);
        this.students = CSV.retrieveStudents((List)this.contents, (boolean)withHeader);
        this.csv = csv;
    }

    public CSV(List contents, boolean withHeader) {
        truncatingWarningDisplayed = false;
        this.headers = CSV.retrieveHeaders((List)contents);
        this.students = CSV.retrieveStudents((List)contents, (boolean)withHeader);
        this.csv = CSV.createFromContents((List)contents);
        this.contents = contents;
    }

    public List getHeaders() {
        return this.headers;
    }

    public List getStudents() {
        return this.students;
    }

    public List getStudentUsernames() {
        ArrayList<String> usernames = new ArrayList<String>();
        for (List s1 : this.students) {
            String usr = ((String)s1.get(0)).trim();
            usernames.add(usr);
        }
        return usernames;
    }

    public String getCsv() {
        return this.csv;
    }

    public static String createFromContents(List rows) {
        StringBuilder csv = new StringBuilder();
        Iterator riter = rows.iterator();
        while (riter.hasNext()) {
            Iterator citer = ((List)riter.next()).iterator();
            while (citer.hasNext()) {
                String current = (String)citer.next();
                if (current == null) {
                    current = "";
                }
                current = current.replaceAll("\"", "\"\"");
                csv.append("\"");
                csv.append(current);
                csv.append("\"");
                if (!citer.hasNext()) continue;
                csv.append(",");
            }
            if (!riter.hasNext()) continue;
            csv.append("\r\n");
        }
        return csv.toString();
    }

    public static List retrieveContents(String csv, char delimiter) throws DataFormatException {
        ArrayList all = new ArrayList();
        ArrayList<String> current = new ArrayList<String>();
        StringBuilder it = new StringBuilder();
        boolean inQuotes = false;
        int length = csv.length();
        for (int ii = 0; ii < length; ++ii) {
            if (inQuotes) {
                if (ii == length - 1) {
                    current.add(it.length() == 0 ? " " : it.toString());
                    all.add(current);
                    break;
                }
                if (csv.charAt(ii) == '\"') {
                    if (ii < length - 1 && csv.charAt(ii + 1) == '\"') {
                        it.append("\"");
                        ++ii;
                        continue;
                    }
                    inQuotes = false;
                    continue;
                }
                it.append(csv.charAt(ii));
                continue;
            }
            if (ii == length - 1 && csv.charAt(ii) != '\n' && csv.charAt(ii) != '\r') {
                if (csv.charAt(ii) == delimiter) {
                    current.add((it = CSV.truncateIt((StringBuilder)it)).length() == 0 ? " " : it.toString());
                    current.add("");
                } else {
                    it.append(csv.charAt(ii));
                    it = CSV.truncateIt((StringBuilder)it);
                    current.add(it.length() == 0 ? " " : it.toString());
                }
                all.add(current);
                break;
            }
            if (csv.charAt(ii) == delimiter) {
                current.add((it = CSV.truncateIt((StringBuilder)it)).length() == 0 ? " " : it.toString());
                it = new StringBuilder();
                continue;
            }
            if (csv.charAt(ii) == '\r' || csv.charAt(ii) == '\n') {
                if (ii < length - 1 && csv.charAt(ii + 1) == '\n') {
                    ++ii;
                }
                current.add((it = CSV.truncateIt((StringBuilder)it)).length() == 0 ? " " : it.toString());
                it = new StringBuilder();
                all.add(current);
                current = new ArrayList();
                continue;
            }
            if (csv.charAt(ii) == '\"') {
                inQuotes = true;
                continue;
            }
            it.append(csv.charAt(ii));
        }
        int finalNumCols = 0;
        for (int i = 0; i < all.size(); ++i) {
            if (((List)all.get(i)).size() <= finalNumCols) continue;
            finalNumCols = ((List)all.get(i)).size();
        }
        for (int j = 0; j < all.size(); ++j) {
            while (((List)all.get(j)).size() < finalNumCols) {
                ((List)all.get(j)).add(" ");
            }
        }
        return all;
    }

    public static List retrieveHeaders(List rows) {
        if (rows == null || rows.size() == 0) {
            return null;
        }
        return (List)rows.get(0);
    }

    public static List retrieveStudents(List rows, boolean withHeader) {
        List headers = CSV.retrieveHeaders((List)rows);
        ArrayList results = new ArrayList(rows);
        if (withHeader) {
            results.remove(0);
        }
        return results;
    }

    public static int determineColumns(String csv, char delimiter) {
        int total = 0;
        boolean inQuotes = false;
        int length = csv.length();
        for (int ii = 0; ii < length; ++ii) {
            if (inQuotes) {
                if (csv.charAt(ii) != '\"') continue;
                if (ii < length - 1 && csv.charAt(ii + 1) == '\"') {
                    ++ii;
                    continue;
                }
                inQuotes = false;
                continue;
            }
            if (csv.charAt(ii) == delimiter) {
                ++total;
                continue;
            }
            if (csv.charAt(ii) == '\r' || csv.charAt(ii) == '\n') break;
            if (csv.charAt(ii) != '\"') continue;
            inQuotes = true;
        }
        return ++total;
    }

    private static StringBuilder truncateIt(StringBuilder buffer) {
        if (buffer.length() > 2000) {
            String truncatedString = buffer.substring(0, 2000);
            buffer = new StringBuilder();
            buffer.append(truncatedString);
            if (!truncatingWarningDisplayed) {
                truncatingWarningDisplayed = true;
                FacesContext.getCurrentInstance().addMessage(null, MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"data_truncated_warning", (Object[])new Object[]{new Integer(2000)}, (FacesContext)FacesContext.getCurrentInstance()));
            }
        }
        return buffer;
    }
}

