/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.postem;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sakaiproject.jsf.util.JsfTool;
import org.sakaiproject.tool.api.ActiveTool;
import org.sakaiproject.tool.api.ToolException;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.ActiveToolManager;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.util.Web;

public class PostemFilePickerServlet
extends JsfTool {
    private static final String HELPER_EXT = ".helper";
    private static final String HELPER_SESSION_PREFIX = "session.";

    protected void dispatch(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        RequestDispatcher resourceDispatcher;
        String target = req.getPathInfo();
        if (this.sendToHelper(req, res, target)) {
            return;
        }
        if (this.isResourceRequest(target) && (resourceDispatcher = this.getServletContext().getRequestDispatcher(target)) != null) {
            resourceDispatcher.forward((ServletRequest)req, (ServletResponse)res);
            return;
        }
        if ("Title".equals(req.getParameter("panel"))) {
            target = "/title.jsf";
        } else {
            ToolSession session = SessionManager.getCurrentToolSession();
            if (target == null || "/".equals(target)) {
                target = this.computeDefaultTarget();
                if (!target.startsWith("/")) {
                    target = "/" + target;
                }
                res.sendRedirect(Web.returnUrl((HttpServletRequest)req, (String)target));
                return;
            }
            String newTarget = this.redirectRequestedTarget(target);
            if (!newTarget.startsWith("/")) {
                newTarget = "/" + newTarget;
            }
            if (!newTarget.equals(target)) {
                res.sendRedirect(Web.returnUrl((HttpServletRequest)req, (String)newTarget));
                return;
            }
            target = newTarget;
            if (this.m_defaultToLastView) {
                session.setAttribute("sakai.jsf.tool.last.view.visited", (Object)target);
            }
        }
        target = this.m_path + target;
        int lastSlash = target.lastIndexOf("/");
        int lastDot = target.lastIndexOf(".");
        if (lastDot < 0 || lastDot < lastSlash) {
            target = target + ".jsf";
        }
        req.setAttribute("sakai.jsf.tool.URL.path", (Object)this.m_path);
        req.setAttribute("sakai.jsf.tool.URL.ext", (Object)".jsp");
        req.setAttribute("sakai.request.native.url", (Object)"sakai.request.native.url");
        res.setContentType("text/html; charset=UTF-8");
        res.addDateHeader("Expires", System.currentTimeMillis() - 31536000000L);
        res.addDateHeader("Last-Modified", System.currentTimeMillis());
        res.addHeader("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0, post-check=0, pre-check=0");
        res.addHeader("Pragma", "no-cache");
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(target);
        dispatcher.forward((ServletRequest)req, (ServletResponse)res);
        req.removeAttribute("sakai.request.native.url");
        req.removeAttribute("sakai.jsf.tool.URL.path");
        req.removeAttribute("sakai.jsf.tool.URL.ext");
    }

    protected boolean sendToHelper(HttpServletRequest req, HttpServletResponse res, String target) throws ToolException {
        String[] parts;
        String path = req.getPathInfo();
        if (path == null) {
            path = "/";
        }
        if ((parts = path.split("/")).length < 2) {
            return false;
        }
        if (!parts[1].endsWith(HELPER_EXT)) {
            return false;
        }
        ToolSession toolSession = SessionManager.getCurrentToolSession();
        Enumeration params = req.getParameterNames();
        while (params.hasMoreElements()) {
            String paramName = (String)params.nextElement();
            if (!paramName.startsWith(HELPER_SESSION_PREFIX)) continue;
            String attributeName = paramName.substring(HELPER_SESSION_PREFIX.length());
            toolSession.setAttribute(attributeName, (Object)req.getParameter(paramName));
        }
        int posEnd = parts[1].lastIndexOf(".");
        String helperId = target.substring(1, posEnd + 1);
        ActiveTool helperTool = ActiveToolManager.getActiveTool((String)helperId);
        if (toolSession.getAttribute(helperTool.getId() + "sakai.tool.helper.done.url") == null && !target.equals("/sakai.filepicker.helper")) {
            toolSession.setAttribute(helperTool.getId() + "sakai.tool.helper.done.url", (Object)(req.getContextPath() + req.getServletPath() + this.computeDefaultTarget(true)));
        }
        String context = req.getContextPath() + req.getServletPath() + Web.makePath((String[])parts, (int)1, (int)2);
        String toolPath = Web.makePath((String[])parts, (int)2, (int)parts.length);
        helperTool.help(req, res, context, toolPath);
        return true;
    }

    protected String computeDefaultTarget(boolean lastVisited) {
        ToolSession session;
        String last;
        String target = "/" + this.m_default;
        if (lastVisited && (last = (String)(session = SessionManager.getCurrentToolSession()).getAttribute("sakai.jsf.tool.last.view.visited")) != null) {
            target = last;
        }
        return target;
    }
}

