/*
 * Decompiled with CFR 0.152.
 */
package com.corejsf;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;

public class UploadFilter
implements Filter {
    private int sizeThreshold = -1;
    private long sizeMax = -1L;
    private String repositoryPath;

    public void init(FilterConfig config) throws ServletException {
        this.repositoryPath = config.getInitParameter("com.corejsf.UploadFilter.repositoryPath");
        try {
            String paramValue = config.getInitParameter("com.corejsf.UploadFilter.sizeThreshold");
            if (paramValue != null) {
                this.sizeThreshold = Integer.parseInt(paramValue);
            }
            if ((paramValue = config.getInitParameter("com.corejsf.UploadFilter.sizeMax")) != null) {
                this.sizeMax = Long.parseLong(paramValue);
            }
        }
        catch (NumberFormatException ex) {
            ServletException servletEx = new ServletException();
            servletEx.initCause((Throwable)ex);
            throw servletEx;
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        boolean isMultipartContent = FileUpload.isMultipartContent((HttpServletRequest)httpRequest);
        if (!isMultipartContent) {
            chain.doFilter(request, response);
            return;
        }
        DiskFileUpload upload = new DiskFileUpload();
        if (this.repositoryPath != null) {
            upload.setRepositoryPath(this.repositoryPath);
        }
        upload.setHeaderEncoding("UTF-8");
        try {
            List list = upload.parseRequest(httpRequest);
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            for (int i = 0; i < list.size(); ++i) {
                FileItem item = (FileItem)list.get(i);
                if (item.isFormField()) {
                    String str = item.getString("UTF-8");
                    map.put(item.getFieldName(), new String[]{str});
                    continue;
                }
                httpRequest.setAttribute(item.getFieldName(), (Object)item);
            }
            chain.doFilter((ServletRequest)new /* Unavailable Anonymous Inner Class!! */, response);
        }
        catch (FileUploadException ex) {
            ServletException servletEx = new ServletException();
            servletEx.initCause((Throwable)ex);
            throw servletEx;
        }
    }
}

