/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.postem;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.DataFormatException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIData;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.util.MessageUtils;
import org.sakaiproject.api.app.postem.data.Gradebook;
import org.sakaiproject.api.app.postem.data.GradebookManager;
import org.sakaiproject.api.app.postem.data.StudentGrades;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.cover.AuthzGroupService;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.api.FilePickerHelper;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.tool.postem.CSV;
import org.sakaiproject.tool.postem.Column;
import org.sakaiproject.tool.postem.URLConnectionReader;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.sakaiproject.util.ResourceLoader;

/*
 * Exception performing whole class analysis ignored.
 */
public class PostemTool {
    protected GradebookManager gradebookManager;
    protected ArrayList gradebooks;
    protected Gradebook currentGradebook;
    protected TreeMap studentMap;
    protected Gradebook oldGradebook;
    protected String userId;
    protected String userEid;
    protected String filename = null;
    protected String csv = null;
    protected String siteId = null;
    protected UIData gradebookTable;
    protected String title;
    protected String newTemplate;
    protected ArrayList students;
    protected String delimiter;
    protected boolean ascending = true;
    protected String sortBy = "title";
    protected boolean displayErrors;
    protected boolean userPressedBack = false;
    protected boolean gradebooksExist = true;
    private static final int TEMPLATE_MAX_LENGTH = 4000;
    private static final int TITLE_MAX_LENGTH = 255;
    private static final int HEADING_MAX_LENGTH = 500;
    private static final String COMMA_DELIM_STR = "comma";
    private static final String TAB_DELIM_STR = "tab";
    protected StudentGrades currentStudent;
    protected String selectedStudent;
    protected boolean withHeader = true;
    protected int column = 0;
    public static final String messageBundle = "org.sakaiproject.tool.postem.bundle.Messages";
    public ResourceLoader msgs = new ResourceLoader("org.sakaiproject.tool.postem.bundle.Messages");
    private ContentHostingService contentHostingService;
    private static final Log LOG = LogFactory.getLog(PostemTool.class);
    private Boolean editable;
    private List filePickerList;
    private String currentRediredUrl;
    private Reference attachment;

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public ArrayList getGradebooks() {
        String currentSiteId;
        if (this.userId == null) {
            this.userId = SessionManager.getCurrentSessionUserId();
            if (this.userId != null) {
                try {
                    this.userEid = UserDirectoryService.getUserEid((String)this.userId);
                }
                catch (UserNotDefinedException e) {
                    LOG.error((Object)"UserNotDefinedException", (Throwable)e);
                }
            }
        }
        Placement placement = ToolManager.getCurrentPlacement();
        this.siteId = currentSiteId = placement.getContext();
        try {
            this.gradebooks = this.checkAccess() ? new ArrayList(this.gradebookManager.getGradebooksByContext(this.siteId, this.sortBy, this.ascending)) : new ArrayList(this.gradebookManager.getReleasedGradebooksByContext(this.siteId, this.sortBy, this.ascending));
        }
        catch (Exception e) {
            this.gradebooks = null;
        }
        this.gradebooksExist = this.gradebooks != null && this.gradebooks.size() > 0;
        return this.gradebooks;
    }

    public boolean getGradebooksExist() {
        return this.gradebooksExist;
    }

    public String getCsv() {
        return this.csv;
    }

    public void setCsv(String csv) {
        this.csv = csv;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getNewTemplate() {
        return this.newTemplate;
    }

    public void setNewTemplate(String newTemplate) {
        this.newTemplate = newTemplate;
    }

    public GradebookManager getGradebookManager() {
        return this.gradebookManager;
    }

    public void setGradebookManager(GradebookManager gradebookManager) {
        this.gradebookManager = gradebookManager;
    }

    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.contentHostingService = contentHostingService;
    }

    public UIData getGradebookTable() {
        return this.gradebookTable;
    }

    public void setGradebookTable(UIData gradebookTable) {
        this.gradebookTable = gradebookTable;
    }

    public Gradebook getCurrentGradebook() {
        return this.currentGradebook;
    }

    public void setCurrentGradebook(Gradebook currentGradebook) {
        this.currentGradebook = currentGradebook;
    }

    public String getSelectedStudent() {
        return this.selectedStudent;
    }

    public void setSelectedStudent(String selectedStudent) {
        this.selectedStudent = selectedStudent;
    }

    public boolean getWithHeader() {
        return this.withHeader;
    }

    public void setWithHeader(boolean withHeader) {
        this.withHeader = withHeader;
    }

    public boolean getDisplayErrors() {
        return FacesContext.getCurrentInstance().getMessages().hasNext();
    }

    public TreeMap getStudentMap() {
        return this.studentMap;
    }

    public void setDisplayErrors(boolean displayErrors) {
        this.displayErrors = displayErrors;
    }

    public String getCurrentStudentGrades() {
        if (this.currentGradebook == null) {
            return "<p>" + this.msgs.getString("no_gradebook_selected") + "</p>";
        }
        if (this.currentStudent == null) {
            return "<p>" + this.msgs.getFormattedMessage("no_grades_for_user", new Object[]{StringEscapeUtils.escapeHtml((String)this.currentGradebook.getTitle())}) + "</p>";
        }
        return this.currentStudent.formatGrades();
    }

    public String getFirstStudentGrades() {
        if (this.currentGradebook == null) {
            return "<p>" + this.msgs.getString("no_gradebook_selected") + "</p>";
        }
        Set students = this.currentGradebook.getStudents();
        if (students.size() == 0) {
            return "<p>" + this.msgs.getFormattedMessage("no_grades_in_gradebook", new Object[]{StringEscapeUtils.escapeHtml((String)this.currentGradebook.getTitle())}) + "</p>";
        }
        if (this.currentGradebook.getFirstUploadedUsername() != null) {
            StudentGrades student = this.currentGradebook.studentGrades(this.currentGradebook.getFirstUploadedUsername());
            return student.formatGrades();
        }
        StudentGrades student = (StudentGrades)students.iterator().next();
        return student.formatGrades();
    }

    public String getSelectedStudentGrades() {
        if (this.currentGradebook == null) {
            return "<p>" + this.msgs.getString("no_gradebook_selected") + "</p>";
        }
        if (this.currentGradebook.getUsernames() == null || this.currentGradebook.getUsernames().isEmpty()) {
            return "<p>" + this.msgs.getFormattedMessage("no_grades_in_gradebook", new Object[]{StringEscapeUtils.escapeHtml((String)this.currentGradebook.getTitle())}) + "</p>";
        }
        if (this.selectedStudent == null || this.selectedStudent.equals("")) {
            return this.msgs.getString("select_participant");
        }
        StudentGrades selStudent = this.gradebookManager.getStudentByGBAndUsername(this.currentGradebook, this.selectedStudent);
        if (selStudent != null) {
            selStudent.setGradebook(this.currentGradebook);
            return selStudent.formatGrades();
        }
        return this.msgs.getString("select_participant");
    }

    public void toggleSort(String sortByType) {
        if (this.sortBy.equals(sortByType)) {
            this.ascending = !this.ascending;
        } else {
            this.sortBy = sortByType;
            this.ascending = true;
        }
    }

    public String toggleTitleSort() {
        this.toggleSort("title");
        return "main";
    }

    public String toggleCreatorSort() {
        this.toggleSort("creator");
        return "main";
    }

    public String toggleModBySort() {
        this.toggleSort("modBy");
        return "main";
    }

    public String toggleModDateSort() {
        this.toggleSort("modDate");
        return "main";
    }

    public String toggleReleasedSort() {
        this.toggleSort("released");
        return "main";
    }

    public boolean isTitleSort() {
        return this.sortBy.equals("title");
    }

    public boolean isCreatorSort() {
        return this.sortBy.equals("creator");
    }

    public boolean isModBySort() {
        return this.sortBy.equals("modBy");
    }

    public boolean isModDateSort() {
        return this.sortBy.equals("modDate");
    }

    public boolean isReleasedSort() {
        return this.sortBy.equals("released");
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public String processCreateNew() {
        try {
            if (!this.checkAccess()) {
                throw new PermissionException(SessionManager.getCurrentSessionUserId(), "syllabus_access_athz", "");
            }
        }
        catch (PermissionException e) {
            FacesContext.getCurrentInstance().addMessage(null, MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"error_permission", (Object[])new Object[]{e.toString()}, (FacesContext)FacesContext.getCurrentInstance()));
            return "permission_error";
        }
        this.userId = SessionManager.getCurrentSessionUserId();
        this.siteId = ToolManager.getCurrentPlacement().getContext();
        this.currentGradebook = this.gradebookManager.createEmptyGradebook(this.userId, this.siteId);
        this.oldGradebook = this.gradebookManager.createEmptyGradebook(this.userId, this.siteId);
        this.csv = null;
        this.newTemplate = null;
        this.delimiter = "comma";
        return "create_gradebook";
    }

    public String processGradebookUpdate() {
        try {
            if (!this.checkAccess()) {
                throw new PermissionException(SessionManager.getCurrentSessionUserId(), "syllabus_access_athz", "");
            }
        }
        catch (PermissionException e) {
            FacesContext.getCurrentInstance().addMessage(null, MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"error_permission", (Object[])new Object[]{e.toString()}, (FacesContext)FacesContext.getCurrentInstance()));
            this.currentGradebook = null;
            this.csv = null;
            this.newTemplate = null;
            return "permission_error";
        }
        this.userId = SessionManager.getCurrentSessionUserId();
        this.siteId = ToolManager.getCurrentPlacement().getContext();
        Long currentGbId = ((Gradebook)this.gradebookTable.getRowData()).getId();
        this.currentGradebook = this.gradebookManager.getGradebookByIdWithHeadingsAndStudents(currentGbId);
        this.oldGradebook = this.gradebookManager.createEmptyGradebook(this.currentGradebook.getCreator(), this.currentGradebook.getContext());
        this.oldGradebook.setId(this.currentGradebook.getId());
        this.oldGradebook.setStudents(this.currentGradebook.getStudents());
        this.gradebooks = null;
        if (this.currentGradebook.getFileReference() != null) {
            this.attachment = EntityManager.newReference((String)this.contentHostingService.getReference(this.currentGradebook.getFileReference()));
        }
        this.csv = null;
        this.newTemplate = null;
        this.delimiter = "comma";
        return "create_gradebook";
    }

    public static void populateMessage(FacesMessage.Severity severity, String messageId, Object[] args) {
        ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.postem.bundle.Messages");
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(rb.getFormattedMessage(messageId, args)));
    }

    protected static void clearMessages() {
        Iterator iter = FacesContext.getCurrentInstance().getMessages(null);
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    public String processCreate() {
        try {
            if (!this.checkAccess()) {
                throw new PermissionException(SessionManager.getCurrentSessionUserId(), "syllabus_access_athz", "");
            }
        }
        catch (PermissionException e) {
            FacesContext.getCurrentInstance().addMessage(null, MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"error_permission", (Object[])new Object[]{e.toString()}, (FacesContext)FacesContext.getCurrentInstance()));
            this.currentGradebook = null;
            this.csv = null;
            this.newTemplate = null;
            return "permission_error";
        }
        if (this.currentGradebook.getId() == null) {
            ArrayList gb = this.getGradebooks();
            Iterator gi = gb.iterator();
            while (gi.hasNext()) {
                if (!((Gradebook)gi.next()).getTitle().equals(this.currentGradebook.getTitle())) continue;
                PostemTool.clearMessages();
                PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"duplicate_title", (Object[])new Object[0]);
                return "create_gradebook";
            }
        }
        if (this.currentGradebook.getTitle() == null || this.currentGradebook.getTitle().equals("")) {
            PostemTool.clearMessages();
            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"missing_title", (Object[])new Object[0]);
            return "create_gradebook";
        }
        if (this.currentGradebook.getTitle().trim().length() > 255) {
            PostemTool.clearMessages();
            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"title_too_long", (Object[])new Object[]{new Integer(this.currentGradebook.getTitle().trim().length()), new Integer(255)});
            return "create_gradebook";
        }
        Reference attachment = this.getAttachmentReference();
        if (attachment == null) {
            return "create_gradebook";
        }
        if (!this.delimiter.equals("comma") && !this.delimiter.equals("tab")) {
            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"invalid_delim", (Object[])new Object[0]);
            return "create_gradebook";
        }
        if (attachment != null) {
            try {
                ContentResource cr;
                char csv_delim = ',';
                if (this.delimiter.equals("tab")) {
                    csv_delim = '\t';
                }
                if ("text/url".equalsIgnoreCase((cr = this.contentHostingService.getResource(attachment.getId())).getContentType())) {
                    String csvURL = new String(cr.getContent());
                    this.csv = URLConnectionReader.getText((String)csvURL);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)this.csv);
                    }
                } else {
                    this.csv = new String(cr.getContent());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)this.csv);
                    }
                }
                CSV grades = new CSV(this.csv, this.withHeader, csv_delim);
                if (this.withHeader && grades.getHeaders() != null) {
                    List headingList = grades.getHeaders();
                    for (int col = 0; col < headingList.size(); ++col) {
                        String heading = headingList.get(col).toString().trim();
                        if (heading == null || heading.equals("")) {
                            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"blank_headings", (Object[])new Object[0]);
                            return "create_gradebook";
                        }
                        if (heading.length() <= 500) continue;
                        PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"heading_too_long", (Object[])new Object[]{new Integer(500)});
                        return "create_gradebook";
                    }
                }
                if (grades.getStudents() != null) {
                    if (!this.usernamesValid(grades)) {
                        return "create_gradebook";
                    }
                    if (this.hasADuplicateUsername(grades)) {
                        return "create_gradebook";
                    }
                }
                if (this.newTemplate != null && this.newTemplate.trim().length() > 0 && this.newTemplate.trim().length() > 4000) {
                    PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"template_too_long", (Object[])new Object[]{new Integer(this.newTemplate.trim().length()), new Integer(4000)});
                    return "create_gradebook";
                }
                if (this.withHeader && grades.getHeaders() != null) {
                    PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"has_headers", (Object[])new Object[0]);
                }
                if (grades.getStudents() != null) {
                    PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"has_students", (Object[])new Object[]{new Integer(grades.getStudents().size())});
                }
                if (this.withHeader) {
                    this.currentGradebook.setHeadings(grades.getHeaders());
                }
                List slist = grades.getStudents();
                if (this.oldGradebook.getId() != null && !this.userPressedBack) {
                    Set oldStudents = this.currentGradebook.getStudents();
                    this.oldGradebook.setStudents(oldStudents);
                }
                this.currentGradebook.setStudents(new TreeSet());
                for (List ss : slist) {
                    String uname = ((String)ss.remove(0)).trim();
                    this.gradebookManager.createStudentGradesInGradebook(uname, ss, this.currentGradebook);
                    if (this.currentGradebook.getStudents().size() != 1) continue;
                    this.currentGradebook.setFirstUploadedUsername(uname);
                }
            }
            catch (DataFormatException exception) {
                PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)exception.getMessage(), (Object[])new Object[0]);
                return "create_gradebook";
            }
            catch (IdUnusedException e) {
                PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)e.getMessage(), (Object[])new Object[0]);
                return "create_gradebook";
            }
            catch (TypeException e) {
                PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)e.getMessage(), (Object[])new Object[0]);
                return "create_gradebook";
            }
            catch (PermissionException e) {
                PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)e.getMessage(), (Object[])new Object[0]);
                return "create_gradebook";
            }
            catch (ServerOverloadException e) {
                PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)e.getMessage(), (Object[])new Object[0]);
                return "create_gradebook";
            }
            catch (IOException e) {
                PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)e.getMessage(), (Object[])new Object[0]);
                return "create_gradebook";
            }
        } else if (this.csv != null) {
            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"has_students", (Object[])new Object[]{new Integer(0)});
            this.currentGradebook.setHeadings(new ArrayList());
            if (this.oldGradebook.getId() != null) {
                Set oldStudents = this.currentGradebook.getStudents();
                this.oldGradebook.setStudents(oldStudents);
            }
            this.currentGradebook.setStudents(new TreeSet());
        }
        if (this.newTemplate != null && this.newTemplate.trim().length() > 0) {
            this.currentGradebook.setTemplate(this.gradebookManager.createTemplate(this.newTemplate.trim()));
        } else if (this.newTemplate != null) {
            this.currentGradebook.setTemplate(null);
        }
        if (this.csv != null && this.csv.trim().length() > 0 || this.newTemplate != null && this.newTemplate.trim().length() > 0) {
            this.csv = null;
            this.newTemplate = null;
            return "verify";
        }
        Iterator oi = this.oldGradebook.getStudents().iterator();
        while (oi.hasNext()) {
            this.gradebookManager.deleteStudentGrades((StudentGrades)oi.next());
        }
        this.userId = SessionManager.getCurrentSessionUserId();
        this.currentGradebook.setLastUpdated(new Timestamp(new Date().getTime()));
        this.currentGradebook.setLastUpdater(this.userId);
        this.gradebookManager.saveGradebook(this.currentGradebook);
        this.currentGradebook = null;
        this.oldGradebook = null;
        this.withHeader = true;
        return "main";
    }

    public String processCreateOk() {
        Iterator oi = this.oldGradebook.getStudents().iterator();
        while (oi.hasNext()) {
            this.gradebookManager.deleteStudentGrades((StudentGrades)oi.next());
        }
        this.userId = SessionManager.getCurrentSessionUserId();
        this.currentGradebook.setLastUpdated(new Timestamp(new Date().getTime()));
        this.currentGradebook.setLastUpdater(this.userId);
        this.currentGradebook.setFileReference(this.attachment.getId());
        this.gradebookManager.saveGradebook(this.currentGradebook);
        this.currentGradebook = null;
        this.oldGradebook = null;
        this.withHeader = true;
        return "main";
    }

    public String processCreateBack() {
        if (this.currentGradebook.getId() == null) {
            this.csv = null;
            this.currentGradebook.setStudents(null);
        }
        this.userPressedBack = true;
        return "create_gradebook";
    }

    public String processCancelNew() {
        this.currentGradebook = null;
        this.csv = null;
        this.newTemplate = null;
        return "main";
    }

    public String processCancelView() {
        this.currentGradebook = null;
        this.csv = null;
        this.newTemplate = null;
        this.students = null;
        return "main";
    }

    public String processGradebookView() {
        Long currentGbId = ((Gradebook)this.gradebookTable.getRowData()).getId();
        if (this.isEditable()) {
            this.currentGradebook = this.gradebookManager.getGradebookByIdWithHeadings(currentGbId);
            this.currentGradebook.setUsernames(this.gradebookManager.getUsernamesInGradebook(this.currentGradebook));
            this.studentMap = this.currentGradebook.getStudentMap();
            this.setSelectedStudent((String)this.studentMap.firstKey());
            return "view_student";
        }
        this.currentGradebook = this.gradebookManager.getGradebookByIdWithHeadings(currentGbId);
        this.userId = SessionManager.getCurrentSessionUserId();
        this.currentStudent = this.gradebookManager.getStudentByGBAndUsername(this.currentGradebook, this.userEid);
        if (this.currentStudent != null) {
            this.currentStudent.setLastChecked(new Timestamp(new Date().getTime()));
            this.gradebookManager.updateStudent(this.currentStudent);
            this.currentStudent.setGradebook(this.currentGradebook);
        }
        return "view_grades";
    }

    public String processInstructorView() {
        try {
            if (!this.checkAccess()) {
                throw new PermissionException(SessionManager.getCurrentSessionUserId(), "syllabus_access_athz", "");
            }
        }
        catch (PermissionException e) {
            FacesContext.getCurrentInstance().addMessage(null, MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"error_permission", (Object[])new Object[]{e.toString()}, (FacesContext)FacesContext.getCurrentInstance()));
            return "permission_error";
        }
        Long currentGbId = ((Gradebook)this.gradebookTable.getRowData()).getId();
        this.currentGradebook = this.gradebookManager.getGradebookByIdWithHeadingsAndStudents(currentGbId);
        this.students = new ArrayList(this.currentGradebook.getStudents());
        return "view_gradebook";
    }

    public String processGradebookDelete() {
        try {
            if (!this.checkAccess()) {
                throw new PermissionException(SessionManager.getCurrentSessionUserId(), "syllabus_access_athz", "");
            }
        }
        catch (PermissionException e) {
            FacesContext.getCurrentInstance().addMessage(null, MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"error_permission", (Object[])new Object[]{e.toString()}, (FacesContext)FacesContext.getCurrentInstance()));
            return "permission_error";
        }
        Long currentGbId = ((Gradebook)this.gradebookTable.getRowData()).getId();
        this.currentGradebook = this.gradebookManager.getGradebookByIdWithHeadingsAndStudents(currentGbId);
        return "delete_confirm";
    }

    public String processDelete() {
        try {
            if (!this.checkAccess()) {
                throw new PermissionException(SessionManager.getCurrentSessionUserId(), "syllabus_access_athz", "");
            }
        }
        catch (PermissionException e) {
            FacesContext.getCurrentInstance().addMessage(null, MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"error_permission", (Object[])new Object[]{e.toString()}, (FacesContext)FacesContext.getCurrentInstance()));
            return "permission_error";
        }
        this.gradebookManager.deleteGradebook(this.currentGradebook);
        this.gradebooks = null;
        this.currentGradebook = null;
        this.csv = null;
        this.newTemplate = null;
        this.students = null;
        return "main";
    }

    public String processCsvDownload() {
        try {
            if (!this.checkAccess()) {
                throw new PermissionException(SessionManager.getCurrentSessionUserId(), "syllabus_access_athz", "");
            }
        }
        catch (PermissionException e) {
            FacesContext.getCurrentInstance().addMessage(null, MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"error_permission", (Object[])new Object[]{e.toString()}, (FacesContext)FacesContext.getCurrentInstance()));
            return "permission_error";
        }
        Long currentGbId = ((Gradebook)this.gradebookTable.getRowData()).getId();
        this.currentGradebook = this.gradebookManager.getGradebookByIdWithHeadingsAndStudents(currentGbId);
        ArrayList<List> csvContents = new ArrayList<List>();
        if (this.currentGradebook.getHeadings().size() > 0) {
            csvContents.add(this.currentGradebook.getHeadings());
        }
        Iterator si = this.currentGradebook.getStudents().iterator();
        while (si.hasNext()) {
            ArrayList<String> sgl = new ArrayList<String>();
            StudentGrades sg = (StudentGrades)si.next();
            sgl.add(sg.getUsername());
            sgl.addAll(sg.getGrades());
            csvContents.add(sgl);
        }
        CSV newCsv = new CSV(csvContents, this.currentGradebook.getHeadings().size() > 0);
        this.csv = newCsv.getCsv();
        return "download_csv";
    }

    public String processTemplateDownload() {
        try {
            if (!this.checkAccess()) {
                throw new PermissionException(SessionManager.getCurrentSessionUserId(), "syllabus_access_athz", "");
            }
        }
        catch (PermissionException e) {
            FacesContext.getCurrentInstance().addMessage(null, MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"error_permission", (Object[])new Object[]{e.toString()}, (FacesContext)FacesContext.getCurrentInstance()));
            return "permission_error";
        }
        this.currentGradebook = (Gradebook)this.gradebookTable.getRowData();
        return "download_template";
    }

    public ArrayList getStudents() {
        return this.students;
    }

    public String getTitle() {
        return ToolManager.getCurrentTool().getTitle();
    }

    public boolean isEditable() {
        if (this.editable == null) {
            this.editable = this.checkAccess();
        }
        return this.editable;
    }

    public boolean checkAccess() {
        return SiteService.allowUpdateSite((String)ToolManager.getCurrentPlacement().getContext());
    }

    public Map getStatsColumns() {
        TreeMap<String, Integer> columns = new TreeMap<String, Integer>();
        if (this.currentGradebook == null) {
            return columns;
        }
        Set students = this.currentGradebook.getStudents();
        if (students.size() == 0) {
            return columns;
        }
        StudentGrades student = (StudentGrades)students.iterator().next();
        int size = student.getGrades().size();
        for (int current = 0; current < size; ++current) {
            Column nc = new Column(this.currentGradebook, current);
            if (nc.getSummary() == null) continue;
            if (nc.getHasName()) {
                columns.put(nc.getName(), new Integer(current));
                continue;
            }
            columns.put(Integer.toString(current), new Integer(current));
        }
        return columns;
    }

    public Column getCurrentColumn() {
        return new Column(this.currentGradebook, this.column);
    }

    private boolean hasADuplicateUsername(CSV studentGrades) {
        List usernameList = studentGrades.getStudentUsernames();
        ArrayList<String> duplicatesList = new ArrayList<String>();
        while (usernameList.size() > 0) {
            String username = (String)usernameList.get(0);
            usernameList.remove(username);
            if (!usernameList.contains(username) || duplicatesList.contains(username)) continue;
            duplicatesList.add(username);
        }
        if (duplicatesList.size() <= 0) {
            return false;
        }
        if (duplicatesList.size() == 1) {
            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"single_duplicate_username", (Object[])new Object[0]);
        } else {
            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"mult_duplicate_usernames", (Object[])new Object[0]);
        }
        for (int i = 0; i < duplicatesList.size(); ++i) {
            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"duplicate_username", (Object[])new Object[]{duplicatesList.get(i)});
        }
        PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"duplicate_username_dir", (Object[])new Object[0]);
        return true;
    }

    private boolean usernamesValid(CSV studentGrades) {
        boolean usersAreValid = true;
        ArrayList<Integer> blankRows = new ArrayList<Integer>();
        ArrayList<String> invalidUsernames = new ArrayList<String>();
        int row = 1;
        List siteMembers = this.getSiteMembers();
        List studentList = studentGrades.getStudentUsernames();
        Iterator studentIter = studentList.iterator();
        while (studentIter.hasNext()) {
            ++row;
            String usr = (String)studentIter.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("usernamesValid : username=" + usr));
                LOG.debug((Object)("usernamesValid : siteMembers" + siteMembers));
            }
            if (usr == null || usr.equals("")) {
                usersAreValid = false;
                blankRows.add(new Integer(row));
                continue;
            }
            if (siteMembers != null && (siteMembers == null || siteMembers.contains(this.getUserDefined(usr)))) continue;
            usersAreValid = false;
            invalidUsernames.add(usr);
        }
        if (blankRows.size() == 1) {
            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"missing_single_username", (Object[])new Object[0]);
            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"missing_location", (Object[])new Object[]{blankRows.get(0)});
            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"missing_username_dir", (Object[])new Object[0]);
        } else if (blankRows.size() > 1) {
            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"missing_mult_usernames", (Object[])new Object[0]);
            for (int i = 0; i < blankRows.size(); ++i) {
                PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"missing_location", (Object[])new Object[]{blankRows.get(i)});
            }
            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"missing_username_dir", (Object[])new Object[0]);
        }
        if (invalidUsernames.size() == 1) {
            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"blank", (Object[])new Object[0]);
            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"single_invalid_username", (Object[])new Object[0]);
            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"invalid_username", (Object[])new Object[]{invalidUsernames.get(0)});
            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"single_invalid_username_dir", (Object[])new Object[0]);
        } else if (invalidUsernames.size() > 1) {
            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"blank", (Object[])new Object[0]);
            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"mult_invalid_usernames", (Object[])new Object[0]);
            for (int j = 0; j < invalidUsernames.size(); ++j) {
                PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"invalid_username", (Object[])new Object[]{invalidUsernames.get(j)});
            }
            PostemTool.populateMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"mult_invalid_usernames_dir", (Object[])new Object[0]);
        }
        return usersAreValid;
    }

    private boolean isSiteMember(String uid) {
        try {
            AuthzGroup realm = AuthzGroupService.getAuthzGroup((String)("/site/" + this.getCurrentSiteId()));
            return realm.getUsers().contains(uid);
        }
        catch (GroupNotDefinedException e) {
            LOG.error((Object)"IdUnusedException:", (Throwable)e);
            return false;
        }
    }

    private String getCurrentSiteId() {
        Placement placement = ToolManager.getCurrentPlacement();
        return placement.getContext();
    }

    private String getUserDefined(String usr) {
        String userId = usr;
        try {
            User userinfo = UserDirectoryService.getUser((String)usr);
            userId = userinfo.getId();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getUserDefined: username for " + usr + " is " + userId));
            }
            return userId;
        }
        catch (UserNotDefinedException e) {
            block5: {
                try {
                    User userinfo = UserDirectoryService.getUserByEid((String)usr);
                    userId = userinfo.getId();
                }
                catch (UserNotDefinedException ee) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug((Object)("getUserDefined: User Not Defined" + userId));
                }
            }
            return userId;
        }
    }

    private List getSiteMembers() {
        ArrayList siteMembers = new ArrayList();
        try {
            AuthzGroup realm = AuthzGroupService.getAuthzGroup((String)("/site/" + this.getCurrentSiteId()));
            siteMembers = new ArrayList(realm.getUsers());
        }
        catch (GroupNotDefinedException e) {
            LOG.error((Object)"GroupNotDefinedException:", (Throwable)e);
        }
        return siteMembers;
    }

    public String processAddAttachRedirect() {
        try {
            this.filePickerList = EntityManager.newReferenceList();
            ToolSession currentToolSession = SessionManager.getCurrentToolSession();
            currentToolSession.setAttribute("filepicker.attach_cardinality", (Object)FilePickerHelper.CARDINALITY_SINGLE);
            currentToolSession.setAttribute("sakaiproject.filepicker.attachments", (Object)this.filePickerList);
            ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
            context.redirect("sakai.filepicker.helper/tool");
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)(this + ".processAddAttachRedirect - " + e));
            e.printStackTrace();
            return null;
        }
    }

    public String getCurrentRediredUrl() {
        return this.currentRediredUrl;
    }

    public void setCurrentRediredUrl(String currentRediredUrl) {
        this.currentRediredUrl = currentRediredUrl;
    }

    public Reference getAttachmentReference() {
        ToolSession session = SessionManager.getCurrentToolSession();
        if (session.getAttribute("sakaiproject.filepicker.cancel") == null && session.getAttribute("sakaiproject.filepicker.attachments") != null) {
            List refs = (List)session.getAttribute("sakaiproject.filepicker.attachments");
            Reference ref = null;
            if (refs.size() == 1) {
                this.attachment = ref = (Reference)refs.get(0);
            }
        }
        session.removeAttribute("sakaiproject.filepicker.attachments");
        session.removeAttribute("sakaiproject.filepicker.cancel");
        if (this.filePickerList != null) {
            this.filePickerList.clear();
        }
        return this.attachment;
    }

    public String getAttachmentTitle() {
        return this.getReferenceTitle(this.getAttachmentReference());
    }

    public void setAttachment(Reference attachment) {
        this.attachment = attachment;
    }

    public String getReferenceTitle(Reference ref) {
        if (ref != null && ref.getProperties() != null) {
            return ref.getProperties().getProperty(ref.getProperties().getNamePropDisplayName());
        }
        return null;
    }
}

