/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter;

import java.text.MessageFormat;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.filter.CacheFilter;
import org.radeox.filter.context.FilterContext;
import org.radeox.filter.regex.LocaleRegexTokenFilter;
import org.radeox.regex.MatchResult;

public class HeadingFilter
extends LocaleRegexTokenFilter
implements CacheFilter {
    private MessageFormat formatter;

    @Override
    protected String getLocaleKey() {
        return "filter.heading";
    }

    @Override
    public void handleMatch(StringBuffer buffer, MatchResult result, FilterContext context) {
        buffer.append(this.handleMatch(result, context));
    }

    @Override
    public void setInitialContext(InitialRenderContext context) {
        super.setInitialContext(context);
        String outputTemplate = this.outputMessages.getString(this.getLocaleKey() + ".print");
        this.formatter = new MessageFormat("");
        this.formatter.applyPattern(outputTemplate);
    }

    public String handleMatch(MatchResult result, FilterContext context) {
        String name = "";
        char[] nameChars = result.group(3).toCharArray();
        int end = 0;
        for (int i = 0; i < nameChars.length; ++i) {
            if (!Character.isLetterOrDigit(nameChars[i])) continue;
            nameChars[end++] = nameChars[i];
        }
        if (end > 0) {
            name = new String(nameChars, 0, end);
        }
        return this.formatter.format(new Object[]{result.group(1).replace('.', '-'), result.group(3), name});
    }
}

