/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter.balance;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Balancer {
    private static final Log log = LogFactory.getLog(Balancer.class);
    StringBuffer sb;
    TagStack tagStack;
    TagStack rememberedStack;
    Matcher m;
    int head;

    public String filter() {
        this.sb = new StringBuffer();
        this.tagStack = new TagStack();
        this.rememberedStack = new TagStack();
        this.m.reset();
        this.head = -1;
        while (this.m.find()) {
            if (this.m.group(1) != null) {
                this.tagStack.push(new Tag(this.m.group(2), this.m.group(1)));
                if (this.rememberedStack.size() > 0 && this.head < this.m.start()) {
                    this.emitOpenWithRemembered();
                } else {
                    this.emitOpen();
                }
            } else if (this.rememberedStack.size() > 0 && this.head < this.m.start()) {
                this.emitCloseWithRemembered();
            } else {
                this.emitClose();
            }
            this.head = this.m.end();
        }
        this.m.appendTail(this.sb);
        return this.sb.toString();
    }

    private void emitClose() {
        this.doClosing(new StringBuffer());
    }

    private void emitCloseWithRemembered() {
        Iterator it = this.rememberedStack.iterator();
        while (it.hasNext()) {
            Tag tag = (Tag)it.next();
            this.sb.append(tag.open);
        }
        StringBuffer replacementBuffer = new StringBuffer();
        Iterator it2 = this.rememberedStack.backIterator();
        while (it2.hasNext()) {
            Tag tag = (Tag)it2.next();
            replacementBuffer.append("</").append(tag.name).append(">");
        }
        this.doClosing(replacementBuffer);
    }

    private void doClosing(StringBuffer replacementBuffer) {
        Tag currentTag = new Tag(this.m.group(4));
        if (this.tagStack.search(currentTag) > -1) {
            Tag tag = this.tagStack.pop();
            while (this.tagStack.size() > 0 && !currentTag.equals(tag)) {
                if (tag != null) {
                    replacementBuffer.append("</").append(tag.name).append(">");
                    this.rememberedStack.push(tag);
                } else {
                    log.warn((Object)"Found Null tag in ballancer ");
                }
                tag = this.tagStack.pop();
            }
            replacementBuffer.append("</").append(currentTag.name).append(">");
        } else {
            TagStack tempStack = new TagStack();
            Tag tag = this.rememberedStack.pop();
            while (this.rememberedStack.size() > 0 && !currentTag.equals(tag)) {
                if (tag != null) {
                    tempStack.push(tag);
                }
                tag = this.rememberedStack.pop();
            }
            tag = tempStack.pop();
            while (tag != null) {
                this.rememberedStack.push(tag);
                tag = tempStack.pop();
            }
        }
        this.m.appendReplacement(this.sb, replacementBuffer.toString());
    }

    public void setMatcher(Matcher matcher) {
        this.m = matcher;
    }

    private void emitOpenWithRemembered() {
        Iterator it = this.rememberedStack.iterator();
        while (it.hasNext()) {
            Tag tag = (Tag)it.next();
            this.sb.append(tag.open);
        }
        StringBuffer buffer = new StringBuffer();
        Iterator it2 = this.rememberedStack.backIterator();
        while (it2.hasNext()) {
            Tag tag = (Tag)it2.next();
            buffer.append("</").append(tag.name).append(">");
        }
        buffer.append(this.m.group(1).replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$"));
        this.m.appendReplacement(this.sb, buffer.toString());
    }

    private void emitOpen() {
        this.m.appendReplacement(this.sb, "$1");
    }

    class TagStack {
        List internalList = new ArrayList();
        int size = 0;

        public Tag push(Tag toPush) {
            this.internalList.add(this.size++, toPush);
            if (this.size > 1) {
                return (Tag)this.internalList.get(this.size - 2);
            }
            return null;
        }

        public Tag peek() {
            if (this.size > 0) {
                return (Tag)this.internalList.get(this.size - 1);
            }
            return null;
        }

        public Tag pop() {
            if (this.size > 0) {
                return (Tag)this.internalList.get(--this.size);
            }
            return null;
        }

        public int size() {
            return this.size;
        }

        public boolean empty() {
            return this.size == 0;
        }

        public int search(Tag o) {
            if (o == null) {
                return -1;
            }
            for (int i = this.size; i > 0; --i) {
                if (!o.equals(this.internalList.get(i - 1))) continue;
                return this.size - i + 1;
            }
            return -1;
        }

        public Tag get(int i) {
            if (i < this.size) {
                return (Tag)this.internalList.get(i);
            }
            throw new ArrayIndexOutOfBoundsException(i);
        }

        public Iterator iterator() {
            return new Iterator(){
                int ourHead;
                {
                    this.ourHead = TagStack.this.size;
                }

                @Override
                public boolean hasNext() {
                    return this.ourHead > 0;
                }

                public Object next() {
                    return TagStack.this.internalList.get(--this.ourHead);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove is not implemented for this iterator");
                }
            };
        }

        public Iterator backIterator() {
            return new Iterator(){
                int ourHead = 0;

                @Override
                public boolean hasNext() {
                    return this.ourHead < TagStack.this.size;
                }

                public Object next() {
                    return TagStack.this.internalList.get(this.ourHead++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove is not implemented for this iterator");
                }
            };
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Tag t = (Tag)it.next();
                sb.append("Tag: " + t.open + "\n");
            }
            return sb.toString();
        }
    }

    class Tag {
        public String name;
        public String open;

        public Tag(String name, String open) {
            this.name = name;
            this.open = open;
        }

        public Tag(String name) {
            this.name = name;
            this.open = null;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof Tag) {
                Tag that = (Tag)o;
                if (that.name == null && this.name == null) {
                    return true;
                }
                if (this.name == null) {
                    return false;
                }
                return this.name.equals(that.name);
            }
            return false;
        }
    }
}

