/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro;

import java.io.IOException;
import java.io.Writer;
import org.radeox.Messages;
import org.radeox.api.engine.ImageRenderEngine;
import org.radeox.api.engine.RenderEngine;
import org.radeox.api.engine.context.RenderContext;
import org.radeox.api.macro.MacroParameter;
import org.radeox.macro.BaseLocaleMacro;
import org.radeox.util.Encoder;

public class LinkMacro
extends BaseLocaleMacro {
    private static String[] paramDescription = new String[]{Messages.getString("LinkMacro.0"), Messages.getString("LinkMacro.1"), Messages.getString("LinkMacro.2"), Messages.getString("LinkMacro.3"), Messages.getString("LinkMacro.4")};
    private static String description = Messages.getString("LinkMacro.5");

    @Override
    public String[] getParamDescription() {
        return paramDescription;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public String getLocaleKey() {
        return "macro.link";
    }

    @Override
    public void execute(Writer writer, MacroParameter params) throws IllegalArgumentException, IOException {
        RenderContext context = params.getContext();
        RenderEngine engine = context.getRenderEngine();
        String text = params.get("text", 0);
        String url = params.get("url", 1);
        String img = params.get("img", 2);
        String target = params.get("target", 3);
        if (params.getLength() == 1) {
            url = text;
            text = Encoder.toEntity(text.charAt(0)) + Encoder.escape(text.substring(1));
        }
        if (url != null && text != null) {
            if (target == null) {
                target = url.indexOf("://") >= 0 && url.indexOf("://") < 6 ? "rwikiexternal" : "none";
            }
            url = url.trim();
            target = target.trim();
            text = text.trim();
            writer.write("<span class=\"nobr\">");
            if (!"none".equals(img) && engine instanceof ImageRenderEngine) {
                writer.write(((ImageRenderEngine)engine).getExternalImageLink());
            }
            writer.write("<a href=\"");
            writer.write(url);
            writer.write("\"");
            if (!"none".equals(target)) {
                writer.write(" target=\"");
                writer.write(target);
                writer.write("\" ");
            }
        } else {
            throw new IllegalArgumentException(Messages.getString("LinkMacro.23"));
        }
        writer.write(">");
        writer.write(text);
        writer.write("</a></span>");
    }
}

