/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.test.filter;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.radeox.api.engine.RenderEngine;
import org.radeox.filter.LinkTestFilter;
import org.radeox.test.filter.FilterTestSupport;
import org.radeox.test.filter.mock.MockWikiRenderEngine;

public class LinkTestFilterTest
extends FilterTestSupport {
    public LinkTestFilterTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        this.filter = new LinkTestFilter();
        this.context.getRenderContext().setRenderEngine((RenderEngine)new MockWikiRenderEngine());
        super.setUp();
    }

    public static Test suite() {
        return new TestSuite(LinkTestFilterTest.class);
    }

    public void testUrlInLink() {
        LinkTestFilterTest.assertEquals((String)"Url is reported", (String)"<div class=\"error\">Do not surround URLs with [...].</div>", (String)this.filter.filter("[http://radeox.org]", this.context));
    }

    public void testCreate() {
        LinkTestFilterTest.assertEquals((String)"'Roller' - 'Roller'", (String)this.filter.filter("[Roller]", this.context));
    }

    public void testLink() {
        LinkTestFilterTest.assertEquals((String)"link:SnipSnap|SnipSnap", (String)this.filter.filter("[SnipSnap]", this.context));
    }

    public void testLinkLower() {
        LinkTestFilterTest.assertEquals((String)"link:stephan|stephan", (String)this.filter.filter("[stephan]", this.context));
    }

    public void testLinkAlias() {
        LinkTestFilterTest.assertEquals((String)"link:stephan|alias", (String)this.filter.filter("[alias|stephan]", this.context));
    }

    public void testLinkAliasAnchor() {
        LinkTestFilterTest.assertEquals((String)"link:stephan|alias#hash", (String)this.filter.filter("[alias|stephan#hash]", this.context));
    }

    public void testLinkAliasAnchorType() {
        LinkTestFilterTest.assertEquals((String)"link:stephan|alias#hash", (String)this.filter.filter("[alias|type:stephan#hash]", this.context));
    }

    public void testLinksWithEscapedChars() {
        LinkTestFilterTest.assertEquals((String)"'<link>' - '&#60;link&#62;'", (String)this.filter.filter("[<link>]", this.context));
    }
}

