/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro.table;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.radeox.macro.table.Function;
import org.radeox.macro.table.Table;

public class AvgFunction
implements Function {
    private static Log log = LogFactory.getLog(AvgFunction.class);

    @Override
    public String getName() {
        return "AVG";
    }

    @Override
    public void execute(Table table, int posx, int posy, int startX, int startY, int endX, int endY) {
        float sum = 0.0f;
        int count = 0;
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                try {
                    sum += (float)Integer.parseInt((String)table.getXY(x, y));
                    ++count;
                    continue;
                }
                catch (Exception e) {
                    try {
                        sum += Float.parseFloat((String)table.getXY(x, y));
                        ++count;
                        continue;
                    }
                    catch (NumberFormatException e1) {
                        log.debug((Object)("SumFunction: unable to parse " + table.getXY(x, y)));
                    }
                }
            }
        }
        table.setXY(posx, posy, "" + sum / (float)count);
    }
}

