/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.test.filter;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.filter.EscapeFilter;
import org.radeox.filter.Filter;
import org.radeox.filter.FilterPipe;
import org.radeox.filter.context.FilterContext;
import org.radeox.test.filter.FilterTestSupport;
import org.radeox.util.Encoder;

public class EscapeFilterTest
extends FilterTestSupport {
    public EscapeFilterTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        this.filter = new EscapeFilter();
        super.setUp();
    }

    public static Test suite() {
        return new TestSuite(EscapeFilterTest.class);
    }

    public void testEscapeH() {
        EscapeFilterTest.assertEquals((String)"h is escaped", (String)"&#104;", (String)this.filter.filter("\\h", this.context));
    }

    public void testBackslash() {
        EscapeFilterTest.assertEquals((String)"\\\\ is kept escaped", (String)"\\\\", (String)this.filter.filter("\\\\", this.context));
    }

    public void testBeforeEscape() {
        FilterPipe fp = new FilterPipe();
        Filter f = new Filter(){

            @Override
            public String[] replaces() {
                return new String[0];
            }

            @Override
            public void setInitialContext(InitialRenderContext context) {
            }

            @Override
            public String[] before() {
                return FilterPipe.EMPTY_BEFORE;
            }

            @Override
            public String filter(String input, FilterContext context) {
                return null;
            }

            @Override
            public String getDescription() {
                return "";
            }
        };
        fp.addFilter(f);
        fp.addFilter(this.filter);
        EscapeFilterTest.assertEquals((String)"EscapeFilter is first", (Object)fp.getFilter(0), (Object)this.filter);
    }

    public void testHTMLEncoderEscape() {
        EscapeFilterTest.assertEquals((String)"&#60;link&#62;", (String)Encoder.escape("<link>"));
    }

    public void testHTMLEncoderUnescape() {
        EscapeFilterTest.assertEquals((String)"<link>", (String)Encoder.unescape("&#60;link&#62;"));
    }

    public void testAmpersandEscape() {
        EscapeFilterTest.assertEquals((String)"&#38;", (String)this.filter.filter("&", this.context));
    }
}

