/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.test.filter;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.radeox.filter.ListFilter;
import org.radeox.test.filter.FilterTestSupport;

public class ListFilterTest
extends FilterTestSupport {
    public ListFilterTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        this.filter = new ListFilter();
        super.setUp();
    }

    public static Test suite() {
        return new TestSuite(ListFilterTest.class);
    }

    public void testListsWithStrike() {
        ListFilterTest.assertEquals((String)"<ul class=\"minus\">\n<li>test</li>\n<li>test</li>\n<li>test</li>\n</ul>", (String)this.filter.filter("- test\n- test\n\n-----\n\n- test", this.context));
    }

    public void testUnnumberedListTwoItems() {
        ListFilterTest.assertEquals((String)"<ul class=\"minus\">\n<li>test</li>\n<li>test</li>\n</ul>", (String)this.filter.filter("- test\n- test", this.context));
    }

    public void testUnnumberedList() {
        ListFilterTest.assertEquals((String)"<ul class=\"minus\">\n<li>test</li>\n</ul>", (String)this.filter.filter("- test", this.context));
    }

    public void testOrderedList() {
        ListFilterTest.assertEquals((String)"<ol>\n<li>test</li>\n<li>test</li>\n<li>test</li>\n</ol>", (String)this.filter.filter("1. test\n1. test\n 1. test", this.context));
    }

    public void testSimpleNestedList() {
        ListFilterTest.assertEquals((String)"<ul class=\"minus\">\n<li>test</li>\n<ul class=\"minus\">\n<li>test</li>\n<li>test</li>\n</ul>\n<li>test</li>\n</ul>", (String)this.filter.filter("- test\r\n-- test\r\n-- test\r\n- test", this.context));
    }

    public void testNestedList() {
        ListFilterTest.assertEquals((String)"<ul class=\"minus\">\n<li>test</li>\n<ol class=\"alpha\">\n<li>test</li>\n<li>test</li>\n</ol>\n<li>test</li>\n</ul>", (String)this.filter.filter("- test\n-a. test\n-a. test\n- test", this.context));
    }

    public void testSequentialLists() {
        ListFilterTest.assertEquals((String)"<ul class=\"minus\">\n<li>test</li>\n</ul>TEXT\n<ul class=\"minus\">\n<li>test</li>\n</ul>", (String)this.filter.filter("- test\nTEXT\n- test", this.context));
    }

    public void testListWithLinks() {
        ListFilterTest.assertEquals((String)"<ul class=\"minus\">\n<li>[test]</li>\n<li>[test1]</li>\n<li>[test test2]</li>\n</ul>", (String)this.filter.filter("- [test]\n- [test1]\n- [test test2]\n", this.context));
    }
}

