/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.test.filter;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.radeox.filter.ParagraphFilter;
import org.radeox.test.filter.FilterTestSupport;

public class ParagraphFilterTest
extends FilterTestSupport {
    public ParagraphFilterTest(String s) {
        super(s);
    }

    @Override
    protected void setUp() throws Exception {
        this.filter = new ParagraphFilter();
        super.setUp();
    }

    public static Test suite() {
        return new TestSuite(ParagraphFilterTest.class);
    }

    public void testParagraph() {
        String result = this.filter.filter("<h1>test</h1>TextA \n\n TextB\n <h2>Head2</h2>", this.context);
        System.err.println(":" + result + ":");
        ParagraphFilterTest.assertEquals((String)"<p class=\"paragraph\"><h1>test</h1>TextA</p><p class=\"paragraph\"> TextB\n <h2>Head2</h2></p>", (String)result);
    }

    public void testParagraph2() {
        String result = this.filter.filter("<h1>test</h1>\n\n TextB\n <h2>Head2</h2>", this.context);
        System.err.println(":" + result + ":");
        ParagraphFilterTest.assertEquals((String)"<p class=\"paragraph\"><h1>test</h1></p><p class=\"paragraph\"> TextB\n <h2>Head2</h2></p>", (String)result);
    }

    public void testParagraph3() {
        String result = this.filter.filter("TextA \n\n TextB\n <h2>Head2</h2>", this.context);
        System.err.println(":" + result + ":");
        ParagraphFilterTest.assertEquals((String)"<p class=\"paragraph\">TextA</p><p class=\"paragraph\"> TextB\n <h2>Head2</h2></p>", (String)result);
    }

    public void testNoChangeParagraph() {
        String result = this.filter.filter("Some __Simple__ Content", this.context);
        System.err.println(":" + result + ":");
        ParagraphFilterTest.assertEquals((String)"Some __Simple__ Content", (String)result);
    }

    public void testDoubleParagraph() {
        String result = this.filter.filter("\n\nSome __Simple__ Content", this.context);
        System.err.println(":" + result + ":");
        ParagraphFilterTest.assertEquals((String)"<p class=\"paragraph\"></p><p class=\"paragraph\">Some __Simple__ Content</p>", (String)result);
    }

    public void testSingleParagraph() {
        String result = this.filter.filter("\nSome __Simple__ Content", this.context);
        System.err.println(":" + result + ":");
        ParagraphFilterTest.assertEquals((String)"\nSome __Simple__ Content", (String)result);
    }

    public void testSingleEmbededParagraph() {
        String result = this.filter.filter("\nSome\n\n__Simple__ Content", this.context);
        System.err.println(":" + result + ":");
        ParagraphFilterTest.assertEquals((String)"<p class=\"paragraph\">\nSome</p><p class=\"paragraph\">__Simple__ Content</p>", (String)result);
    }

    public void testEmbededLinkParagraph() {
        String result = this.filter.filter("sdfdgdfgdd dfgdf gdfg dfgd fgdgf dfg <span class=\"nobr\">\n<img src=\"/sakai-rwiki-tool/images/icklearrow.gif\" alt=\"external link: \" title=\"external link\"/> <a href=\"link\">link</a></span> part of the same paragraph\n\nAnnother paragraph\n\nAnnother paragraph\n", this.context);
        System.err.println(":" + result + ":");
        ParagraphFilterTest.assertEquals((String)"<p class=\"paragraph\">sdfdgdfgdd dfgdf gdfg dfgd fgdgf dfg <span class=\"nobr\">\n<img src=\"/sakai-rwiki-tool/images/icklearrow.gif\" alt=\"external link: \" title=\"external link\"/> <a href=\"link\">link</a></span> part of the same paragraph</p><p class=\"paragraph\">Annother paragraph</p><p class=\"paragraph\">Annother paragraph\n</p>", (String)result);
    }
}

