/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.test.filter;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.radeox.filter.StrikeThroughFilter;
import org.radeox.test.filter.FilterTestSupport;

public class StrikeThroughFilterTest
extends FilterTestSupport {
    public StrikeThroughFilterTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        this.filter = new StrikeThroughFilter();
        super.setUp();
    }

    public static Test suite() {
        return new TestSuite(StrikeThroughFilterTest.class);
    }

    public void testStrikeThroughDash() {
        StrikeThroughFilterTest.assertEquals((String)"Test<strike class=\"strike\">Test-Text</strike>", (String)this.filter.filter("Test--Test-Text--", this.context));
    }

    public void testStrikeThroughDoubleDash() {
        StrikeThroughFilterTest.assertEquals((String)"Test<strike class=\"strike\">Test</strike>Text--", (String)this.filter.filter("Test--Test--Text--", this.context));
    }

    public void testStartStrikeThrough() {
        StrikeThroughFilterTest.assertEquals((String)"Test<strike class=\"strike\">Text</strike>", (String)this.filter.filter("Test--Text--", this.context));
    }

    public void testEndStrikeThrough() {
        StrikeThroughFilterTest.assertEquals((String)"<strike class=\"strike\">Text</strike>Test", (String)this.filter.filter("--Text--Test", this.context));
    }

    public void testStrikeThrough() {
        StrikeThroughFilterTest.assertEquals((String)"Test<strike class=\"strike\">Text</strike>Test", (String)this.filter.filter("Test--Text--Test", this.context));
    }

    public void testFourDashes() {
        StrikeThroughFilterTest.assertEquals((String)"----", (String)this.filter.filter("----", this.context));
    }

    public void testFiveDashes() {
        StrikeThroughFilterTest.assertEquals((String)"-----", (String)this.filter.filter("-----", this.context));
    }

    public void testHtmlComment() {
        StrikeThroughFilterTest.assertEquals((String)"<!-- comment -->", (String)this.filter.filter("<!-- comment -->", this.context));
    }
}

