/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.test.filter;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.radeox.filter.TypographyFilter;
import org.radeox.test.filter.FilterTestSupport;

public class TypographyFilterTest
extends FilterTestSupport {
    public TypographyFilterTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        this.filter = new TypographyFilter();
        super.setUp();
    }

    public static Test suite() {
        return new TestSuite(FilterTestSupport.class);
    }

    public void testElipsis() {
        TypographyFilterTest.assertEquals((String)"Test &#8230; Text", (String)this.filter.filter("Test ... Text", this.context));
    }

    public void testNotAfter() {
        TypographyFilterTest.assertEquals((String)"...Text", (String)this.filter.filter("...Text", this.context));
    }

    public void testEndOfLine() {
        TypographyFilterTest.assertEquals((String)"Text&#8230;", (String)this.filter.filter("Text...", this.context));
    }

    public void test4Dots() {
        TypographyFilterTest.assertEquals((String)"Test .... Text", (String)this.filter.filter("Test .... Text", this.context));
    }

    public void testLineStart() {
        TypographyFilterTest.assertEquals((String)"&#8230; Text", (String)this.filter.filter("... Text", this.context));
    }

    public void testLineEnd() {
        TypographyFilterTest.assertEquals((String)"Test &#8230;", (String)this.filter.filter("Test ...", this.context));
    }
}

