/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.serializer.ToXMLStream;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.filter.CacheFilter;
import org.radeox.filter.Filter;
import org.radeox.filter.FilterPipe;
import org.radeox.filter.context.FilterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class XHTMLFilter
implements Filter,
CacheFilter {
    private static Logger log = LoggerFactory.getLogger(XHTMLFilter.class);
    private static SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private static final Map blockElements = new HashMap();
    private static HashMap emptyTag;
    private static HashMap ignoreEmpty;
    private InitialRenderContext initialContext;

    @Override
    public String filter(String input, FilterContext context) {
        String finalOutput = input;
        try {
            DeblockFilter dbf = new DeblockFilter();
            EmptyFilter epf = new EmptyFilter();
            dbf.setBlockElements(blockElements);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SpecialXHTMLSerializer xser = new SpecialXHTMLSerializer();
            xser.setOutputStream(baos);
            xser.setIndent(false);
            xser.setEncoding("UTF-8");
            xser.setIndentAmount(4);
            dbf.setContentHandler(epf);
            epf.setContentHander(xser.asContentHandler());
            SAXParser parser = saxParserFactory.newSAXParser();
            XMLReader xmlr = parser.getXMLReader();
            xmlr.setContentHandler(dbf);
            xmlr.parse(new InputSource(new StringReader("<sr>" + input + "</sr>")));
            String output = new String(baos.toByteArray(), "UTF-8");
            int startBlock = output.indexOf("<sr>");
            int endBlock = output.indexOf("</sr>");
            if (startBlock >= 0 && endBlock >= 0) {
                finalOutput = output.substring(startBlock + 4, endBlock);
            }
            log.debug("Output is " + finalOutput);
        }
        catch (Throwable t) {
            log.error("Failed to XHTML check " + t.getMessage() + "\n Input======\n" + input + "\n=======");
            return input;
        }
        return finalOutput;
    }

    @Override
    public String[] replaces() {
        return FilterPipe.NO_REPLACES;
    }

    @Override
    public String[] before() {
        return FilterPipe.EMPTY_BEFORE;
    }

    @Override
    public void setInitialContext(InitialRenderContext context) {
        this.initialContext = context;
    }

    @Override
    public String getDescription() {
        return "Hand Coded XHTML filter";
    }

    static {
        saxParserFactory.setNamespaceAware(true);
        ArrayList<String> l = new ArrayList<String>();
        l.add("p");
        blockElements.put("hr", l);
        blockElements.put("h1", l);
        blockElements.put("h2", l);
        blockElements.put("h3", l);
        blockElements.put("h4", l);
        blockElements.put("h5", l);
        blockElements.put("h6", l);
        blockElements.put("h7", l);
        blockElements.put("ul", l);
        blockElements.put("ol", l);
        blockElements.put("div", l);
        blockElements.put("blockquote", l);
        emptyTag = new HashMap();
        emptyTag.put("img", "img");
        emptyTag.put("area", "area");
        emptyTag.put("frame", "frame");
        emptyTag.put("layer", "layer");
        emptyTag.put("embed", "embed");
        emptyTag.put("input", "input");
        emptyTag.put("base", "base");
        emptyTag.put("col", "col");
        emptyTag.put("basefont", "basefont");
        emptyTag.put("link", "link");
        emptyTag.put("meta", "meta");
        emptyTag.put("br", "br");
        emptyTag.put("hr", "hr");
        ignoreEmpty = new HashMap();
        ignoreEmpty.put("p", "p");
    }

    public class SpecialXHTMLSerializer
    extends ToXMLStream {
        private static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";

        public void endElement(String namespaceURI, String localName, String name) throws SAXException {
            if (namespaceURI != null && !"".equals(namespaceURI) && !namespaceURI.equals(XHTML_NAMESPACE) || emptyTag.containsKey(localName.toLowerCase())) {
                super.endElement(namespaceURI, localName, name);
                return;
            }
            this.characters("");
            super.endElement(namespaceURI, localName, name);
        }
    }

    public class EStack {
        Stack restore = null;
        String ns;
        String qname;
        String lname;
        Attributes atts;

        public EStack(String ns, String qname, String lname, Attributes atts, Stack restore) {
            this.ns = ns;
            this.qname = qname;
            this.lname = lname;
            this.atts = new AttributesImpl(atts);
            this.restore = restore;
        }

        public EStack(EStack es) {
            this.ns = es.ns;
            this.qname = es.qname;
            this.lname = es.lname;
            this.atts = new AttributesImpl(es.atts);
            this.restore = es.restore;
        }
    }

    public class EmptyFilter
    implements ContentHandler {
        private ContentHandler next = null;
        private EStack lastElement = null;

        public void setContentHander(ContentHandler handler) {
            this.next = handler;
        }

        @Override
        public void setDocumentLocator(Locator arg0) {
            this.next.setDocumentLocator(arg0);
        }

        @Override
        public void startDocument() throws SAXException {
            this.emitLast();
            this.next.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this.emitLast();
            this.next.endDocument();
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
            this.emitLast();
            this.next.startPrefixMapping(arg0, arg1);
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
            this.emitLast();
            this.next.endPrefixMapping(arg0);
        }

        public void emitLast() throws SAXException {
            if (this.lastElement != null) {
                this.next.startElement(this.lastElement.ns, this.lastElement.qname, this.lastElement.lname, this.lastElement.atts);
                this.lastElement = null;
            }
        }

        @Override
        public void startElement(String ns, String qname, String lname, Attributes atts) throws SAXException {
            this.emitLast();
            if (ignoreEmpty.get(lname.toLowerCase()) != null) {
                this.lastElement = new EStack(ns, qname, lname, atts, null);
            } else {
                this.next.startElement(ns, qname, lname, atts);
            }
        }

        @Override
        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            if (this.lastElement != null) {
                this.lastElement = null;
            } else {
                this.next.endElement(arg0, arg1, arg2);
            }
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            this.emitLast();
            this.next.characters(arg0, arg1, arg2);
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
            this.emitLast();
            this.next.ignorableWhitespace(arg0, arg1, arg2);
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
            this.emitLast();
            this.next.processingInstruction(arg0, arg1);
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
            this.emitLast();
            this.next.skippedEntity(arg0);
        }
    }

    public class DeblockFilter
    implements ContentHandler {
        private Stack s = new Stack();
        private ContentHandler ch;
        private Map blockElements = new HashMap();

        public void setContentHandler(ContentHandler ch) {
            this.ch = ch;
        }

        public void setBlockElements(Map blockElements) {
            this.blockElements = blockElements;
        }

        public void addElement(String blockElement, String unnested) {
            ArrayList<String> l = (ArrayList<String>)this.blockElements.get(blockElement);
            if (l == null) {
                l = new ArrayList<String>();
                this.blockElements.put(blockElement, l);
            }
            l.add(unnested);
        }

        private Stack closeTo(List deblockElements) throws SAXException {
            int firstIndex = this.s.size();
            for (int i = 0; i < this.s.size(); ++i) {
                EStack es = (EStack)this.s.get(i);
                if (!deblockElements.contains(es.lname)) continue;
                firstIndex = i;
            }
            EStack es = null;
            Stack<EStack> sb = new Stack<EStack>();
            while (this.s.size() > firstIndex) {
                es = (EStack)this.s.pop();
                this.ch.endElement(es.ns, es.qname, es.lname);
                sb.push(es);
            }
            return sb;
        }

        @Override
        public void startElement(String ns, String qname, String lname, Attributes atts) throws SAXException {
            if (this.blockElements.get(lname) != null) {
                this.s.push(new EStack(ns, qname, lname, atts, this.closeTo((List)this.blockElements.get(lname))));
            } else {
                this.s.push(new EStack(ns, qname, lname, atts, null));
            }
            this.ch.startElement(ns, qname, lname, atts);
        }

        @Override
        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            this.ch.endElement(arg0, arg1, arg2);
            EStack es = (EStack)this.s.pop();
            if (es.restore != null) {
                while (es.restore.size() > 0) {
                    EStack esr = (EStack)es.restore.pop();
                    this.ch.startElement(esr.ns, esr.qname, esr.lname, esr.atts);
                    this.s.push(esr);
                }
            }
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            this.ch.characters(arg0, arg1, arg2);
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
            this.ch.ignorableWhitespace(arg0, arg1, arg2);
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
            this.ch.processingInstruction(arg0, arg1);
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
            this.ch.skippedEntity(arg0);
        }

        @Override
        public void setDocumentLocator(Locator arg0) {
            this.ch.setDocumentLocator(arg0);
        }

        @Override
        public void startDocument() throws SAXException {
            this.ch.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this.ch.endDocument();
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
            this.ch.startPrefixMapping(arg0, arg1);
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
            this.ch.endPrefixMapping(arg0);
        }
    }
}

