/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter.regex;

import java.util.Locale;
import java.util.ResourceBundle;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.filter.regex.RegexReplaceFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocaleRegexReplaceFilter
extends RegexReplaceFilter {
    private static Logger log = LoggerFactory.getLogger(LocaleRegexReplaceFilter.class);

    protected abstract String getLocaleKey();

    protected boolean isSingleLine() {
        return false;
    }

    protected ResourceBundle getInputBundle() {
        Locale inputLocale = (Locale)this.initialContext.get("RenderContext.input_locale");
        String inputName = (String)this.initialContext.get("RenderContext.input_bundle_name");
        return ResourceBundle.getBundle(inputName, inputLocale);
    }

    protected ResourceBundle getOutputBundle() {
        String outputName = (String)this.initialContext.get("RenderContext.output_bundle_name");
        Locale outputLocale = (Locale)this.initialContext.get("RenderContext.output_locale");
        return ResourceBundle.getBundle(outputName, outputLocale);
    }

    @Override
    public void setInitialContext(InitialRenderContext context) {
        super.setInitialContext(context);
        this.clearRegex();
        ResourceBundle outputMessages = this.getOutputBundle();
        ResourceBundle inputMessages = this.getInputBundle();
        String match = inputMessages.getString(this.getLocaleKey() + ".match");
        String print = outputMessages.getString(this.getLocaleKey() + ".print");
        this.addRegex(match, print, !this.isSingleLine());
    }
}

