/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter.regex;

import org.radeox.filter.context.FilterContext;
import org.radeox.filter.regex.RegexFilter;
import org.radeox.regex.Matcher;
import org.radeox.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexReplaceFilter
extends RegexFilter {
    private static Logger log = LoggerFactory.getLogger(RegexReplaceFilter.class);

    public RegexReplaceFilter() {
    }

    public RegexReplaceFilter(String regex, String substitute) {
        super(regex, substitute);
    }

    public RegexReplaceFilter(String regex, String substitute, boolean multiline) {
        super(regex, substitute, multiline);
    }

    @Override
    public String filter(String input, FilterContext context) {
        String result = input;
        int size = this.pattern.size();
        for (int i = 0; i < size; ++i) {
            Pattern p = (Pattern)this.pattern.get(i);
            String s = (String)this.substitute.get(i);
            try {
                Matcher matcher = Matcher.create(result, p);
                result = matcher.substitute(s);
                continue;
            }
            catch (Exception e) {
                log.warn("Exception for: " + this + " " + e);
                continue;
            }
            catch (Error err) {
                log.warn("Error for: " + this);
                err.printStackTrace();
            }
        }
        return result;
    }
}

