/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro;

import java.util.Locale;
import java.util.ResourceBundle;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.macro.BaseMacro;
import org.radeox.macro.LocaleMacro;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLocaleMacro
extends BaseMacro
implements LocaleMacro {
    private static Logger log = LoggerFactory.getLogger(BaseLocaleMacro.class);
    private String name;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setInitialContext(InitialRenderContext context) {
        super.setInitialContext(context);
        Locale languageLocale = (Locale)context.get("RenderContext.language_locale");
        String languageName = (String)context.get("RenderContext.language_bundle_name");
        ResourceBundle messages = ResourceBundle.getBundle(languageName, languageLocale);
        Locale inputLocale = (Locale)context.get("RenderContext.input_locale");
        String inputName = (String)context.get("RenderContext.input_bundle_name");
        ResourceBundle inputMessages = ResourceBundle.getBundle(inputName, inputLocale);
        this.name = inputMessages.getString(this.getLocaleKey() + ".name");
        try {
            this.description = messages.getString(this.getLocaleKey() + ".description");
        }
        catch (Exception e) {
            log.warn("Cannot read description from properties " + inputName + " for " + this.getLocaleKey());
        }
    }
}

