/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro;

import java.util.Iterator;
import org.radeox.macro.Repository;
import org.radeox.util.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PluginLoader {
    private static Logger log = LoggerFactory.getLogger(PluginLoader.class);
    protected Repository repository;

    public Repository loadPlugins(Repository repository) {
        return this.loadPlugins(repository, this.getLoadClass());
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public Iterator getPlugins(Class klass) {
        return Service.providers(klass);
    }

    public Repository loadPlugins(Repository repository, Class klass) {
        if (null != repository) {
            Iterator iterator = this.getPlugins(klass);
            while (iterator.hasNext()) {
                try {
                    Object plugin = iterator.next();
                    this.add(repository, plugin);
                    log.debug("PluginLoader: Loaded plugin: " + plugin.getClass());
                }
                catch (Exception e) {
                    log.warn("PluginLoader: unable to load plugin", (Throwable)e);
                }
            }
        }
        return repository;
    }

    public abstract void add(Repository var1, Object var2);

    public abstract Class getLoadClass();
}

