/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro;

import java.io.IOException;
import java.io.Writer;
import org.radeox.Messages;
import org.radeox.api.macro.MacroParameter;
import org.radeox.macro.LocalePreserved;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuoteMacro
extends LocalePreserved {
    private static Logger log = LoggerFactory.getLogger(QuoteMacro.class);
    private String[] paramDescription = new String[]{Messages.getString("QuoteMacro.0"), Messages.getString("QuoteMacro.1")};

    @Override
    public String[] getParamDescription() {
        return this.paramDescription;
    }

    @Override
    public String getLocaleKey() {
        return "macro.quote";
    }

    @Override
    public void execute(Writer writer, MacroParameter params) throws IllegalArgumentException, IOException {
        writer.write("<blockquote class=\"quote\"><p class=\"paragraph\">");
        writer.write(params.getContent());
        String source = Messages.getString("QuoteMacro.4");
        if (params.getLength() == 2) {
            source = params.get(1);
        }
        if (params.getLength() > 0) {
            writer.write("<a href=\"" + params.get(0) + "\">");
            writer.write(source);
            writer.write("</a>");
        }
        writer.write("</p></blockquote>");
    }
}

