/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro.table;

import org.radeox.macro.table.Function;
import org.radeox.macro.table.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxFunction
implements Function {
    private static Logger log = LoggerFactory.getLogger(MaxFunction.class);

    @Override
    public String getName() {
        return "MAX";
    }

    @Override
    public void execute(Table table, int posx, int posy, int startX, int startY, int endX, int endY) {
        float max = 0.0f;
        boolean floating = false;
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                float value = 0.0f;
                try {
                    value += (float)Integer.parseInt((String)table.getXY(x, y));
                }
                catch (Exception e) {
                    try {
                        value += Float.parseFloat((String)table.getXY(x, y));
                        floating = true;
                    }
                    catch (NumberFormatException e1) {
                        log.debug("SumFunction: unable to parse " + table.getXY(x, y));
                    }
                }
                if (!(max < value)) continue;
                max = value;
            }
        }
        if (floating) {
            table.setXY(posx, posy, "" + max);
        } else {
            table.setXY(posx, posy, "" + (int)max);
        }
    }
}

