/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.test;

import java.io.IOException;
import java.io.StringWriter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.radeox.EngineManager;
import org.radeox.api.engine.RenderEngine;
import org.radeox.api.engine.context.RenderContext;
import org.radeox.engine.BaseRenderEngine;
import org.radeox.engine.context.BaseRenderContext;
import org.radeox.test.filter.mock.MockWikiRenderEngine;

public class BaseRenderEngineTest
extends TestCase {
    RenderContext context;

    public BaseRenderEngineTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.context = new BaseRenderContext();
        super.setUp();
    }

    public static Test suite() {
        return new TestSuite(BaseRenderEngineTest.class);
    }

    public void testBoldInList() {
        RenderEngine engine = EngineManager.getInstance();
        BaseRenderEngineTest.assertEquals((String)"\n    <ul class=\"minus\">\n        <li>\n<b class=\"bold\">test</b></li></ul>\n", (String)engine.render("- __test__", this.context));
    }

    public void testRenderEngine() {
        String result = EngineManager.getInstance().render("__SnipSnap__ {link:Radeox|http://radeox.org}", this.context);
        BaseRenderEngineTest.assertEquals((String)"\n    <b class=\"bold\">SnipSnap</b> {link:Radeox|<span class=\"nobr\">\n        <a href=\"http://radeox.org\" target=\"rwikiexternal\">http://radeox.org</a></span>}", (String)result);
    }

    public void testEmpty() {
        String result = EngineManager.getInstance().render("", this.context);
        BaseRenderEngineTest.assertEquals((String)"", (String)result);
    }

    public void testDefaultEngine() {
        RenderEngine engine = EngineManager.getInstance();
        RenderEngine engineDefault = EngineManager.getInstance("radeox");
        BaseRenderEngineTest.assertEquals((String)engine.getName(), (String)engineDefault.getName());
    }

    public void testWriter() {
        BaseRenderEngine engine = new BaseRenderEngine();
        StringWriter writer = new StringWriter();
        try {
            engine.render(writer, "__SnipSnap__", this.context);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        BaseRenderEngineTest.assertEquals((String)"BaseRenderEngine writes to Writer", (String)"\n    <b class=\"bold\">SnipSnap</b>", (String)writer.toString());
    }

    public void testFilterOrder() {
        RenderEngine engine = EngineManager.getInstance();
        this.context.setRenderEngine((RenderEngine)new MockWikiRenderEngine());
        BaseRenderEngineTest.assertEquals((String)"'<link>' - '&#60;link&#62;'", (String)engine.render("[<link>]", this.context));
    }

    public void testParagraphTest() {
        RenderEngine engine = EngineManager.getInstance();
        this.context.setRenderEngine((RenderEngine)new MockWikiRenderEngine());
        BaseRenderEngineTest.assertEquals((String)"Some <b class=\"bold\">Simple</b> Content", (String)engine.render("Some __Simple__ Content", this.context));
        this.context.setRenderEngine((RenderEngine)new MockWikiRenderEngine());
        BaseRenderEngineTest.assertEquals((String)"\n    <p class=\"paragraph\">Some</p>\n    <p class=\"paragraph\"> <b class=\"bold\">Simple</b> Content</p>", (String)engine.render("Some\n\n __Simple__ Content", this.context));
    }
}

