/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.test.filter;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.filter.Filter;
import org.radeox.filter.FilterPipe;
import org.radeox.filter.context.FilterContext;
import org.radeox.test.filter.mock.MockReplacedFilter;
import org.radeox.test.filter.mock.MockReplacesFilter;

public class FilterPipeTest
extends TestCase {
    public FilterPipeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public static Test suite() {
        return new TestSuite(FilterPipeTest.class);
    }

    public void testBefore() {
        FilterPipe fp = new FilterPipe();
        Filter f1 = new Filter(){

            @Override
            public String[] before() {
                return FilterPipe.EMPTY_BEFORE;
            }

            @Override
            public void setInitialContext(InitialRenderContext context) {
            }

            @Override
            public String[] replaces() {
                return new String[0];
            }

            @Override
            public String filter(String input, FilterContext context) {
                return null;
            }

            @Override
            public String getDescription() {
                return "";
            }
        };
        Filter f2 = new Filter(){

            @Override
            public String[] before() {
                return FilterPipe.FIRST_BEFORE;
            }

            @Override
            public String[] replaces() {
                return new String[0];
            }

            @Override
            public void setInitialContext(InitialRenderContext context) {
            }

            @Override
            public String filter(String input, FilterContext context) {
                return null;
            }

            @Override
            public String getDescription() {
                return "";
            }
        };
        fp.addFilter(f1);
        fp.addFilter(f2);
        FilterPipeTest.assertEquals((String)"'FIRST_BEFORE Filter is first in FilterPipe", (Object)fp.getFilter(0), (Object)f2);
    }

    public void testReplace() {
        FilterPipe fp = new FilterPipe();
        MockReplacedFilter f1 = new MockReplacedFilter();
        MockReplacesFilter f2 = new MockReplacesFilter();
        fp.addFilter(f1);
        fp.addFilter(f2);
        fp.init();
        FilterPipeTest.assertTrue((String)"MockReplacedFilter is removed from FilterPipe", (-1 == fp.index("org.radeox.test.filter.mock.MockReplacedFilter") ? 1 : 0) != 0);
        FilterPipeTest.assertTrue((String)"MockReplacesFilter is not removed from FilterPipe", (-1 != fp.index("org.radeox.test.filter.mock.MockReplacesFilter") ? 1 : 0) != 0);
    }
}

