/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.radeox.Messages;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.api.macro.MacroParameter;
import org.radeox.filter.context.BaseFilterContext;
import org.radeox.filter.context.FilterContext;
import org.radeox.macro.LocalePreserved;
import org.radeox.macro.code.SourceCodeFormatter;
import org.radeox.util.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeMacro
extends LocalePreserved {
    private static final Logger log = LoggerFactory.getLogger(CodeMacro.class);
    private Map formatters;
    private FilterContext nullContext = new BaseFilterContext();
    private String start;
    private String end;
    private String[] paramDescription = new String[]{Messages.getString("CodeMacro.0")};

    @Override
    public String[] getParamDescription() {
        return this.paramDescription;
    }

    @Override
    public String getLocaleKey() {
        return "macro.code";
    }

    @Override
    public void setInitialContext(InitialRenderContext context) {
        super.setInitialContext(context);
        Locale outputLocale = (Locale)context.get("RenderContext.output_locale");
        String outputName = (String)context.get("RenderContext.output_bundle_name");
        ResourceBundle outputMessages = ResourceBundle.getBundle(outputName, outputLocale);
        this.start = outputMessages.getString(this.getLocaleKey() + ".start");
        this.end = outputMessages.getString(this.getLocaleKey() + ".end");
    }

    public CodeMacro() {
        this.formatters = new HashMap();
        Iterator formatterIt = Service.providers(SourceCodeFormatter.class);
        while (formatterIt.hasNext()) {
            try {
                SourceCodeFormatter formatter = (SourceCodeFormatter)formatterIt.next();
                String name = formatter.getName();
                if (this.formatters.containsKey(name)) {
                    SourceCodeFormatter existing = (SourceCodeFormatter)this.formatters.get(name);
                    if (existing.getPriority() >= formatter.getPriority()) continue;
                    this.formatters.put(name, formatter);
                    log.debug("Replacing formatter: " + formatter.getClass() + " (" + name + ")");
                    continue;
                }
                this.formatters.put(name, formatter);
                log.debug("Loaded formatter: " + formatter.getClass() + " (" + name + ")");
            }
            catch (Exception e) {
                log.warn("CodeMacro: unable to load code formatter", (Throwable)e);
            }
        }
        this.addSpecial('[');
        this.addSpecial(']');
        this.addSpecial('{');
        this.addSpecial('}');
        this.addSpecial('*');
        this.addSpecial('-');
        this.addSpecial('\\');
    }

    @Override
    public void execute(Writer writer, MacroParameter params) throws IllegalArgumentException, IOException {
        String result;
        SourceCodeFormatter formatter = null;
        if (params.getLength() == 0 || !this.formatters.containsKey(params.get("0"))) {
            formatter = (SourceCodeFormatter)this.formatters.get(this.initialContext.get("RenderContext.default_formatter"));
            if (null == formatter) {
                log.error("Formatter not found.");
                formatter = (SourceCodeFormatter)this.formatters.get("java");
            }
        } else {
            formatter = (SourceCodeFormatter)this.formatters.get(params.get("0"));
        }
        if ((result = formatter.filter(params.getContent(), this.nullContext)) == null) {
            result = "";
        }
        result = this.replace(result.trim());
        writer.write(this.start);
        writer.write(result.replaceAll("\n", "&#x0a;"));
        writer.write(this.end);
    }
}

