/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.filter.CacheFilter;
import org.radeox.filter.Filter;
import org.radeox.filter.FilterPipe;
import org.radeox.filter.balance.Balancer;
import org.radeox.filter.context.FilterContext;

public class BalanceFilter
implements Filter,
CacheFilter {
    private InitialRenderContext initialContext;
    public static final String matcherString = "(<([^ />]+)(?: [^>]*?[^/])?>)|(</([^ />]+)>)";

    @Override
    public String[] before() {
        return FilterPipe.EMPTY_BEFORE;
    }

    @Override
    public String filter(String input, FilterContext context) {
        Pattern p = Pattern.compile(matcherString);
        Matcher m = p.matcher(input);
        if (m.find()) {
            return this.actuallyFilter(m);
        }
        return input;
    }

    private String actuallyFilter(Matcher m) {
        Balancer b = new Balancer();
        b.setMatcher(m);
        return b.filter();
    }

    @Override
    public String getDescription() {
        return "Balancing XML Filter";
    }

    @Override
    public String[] replaces() {
        return FilterPipe.NO_REPLACES;
    }

    @Override
    public void setInitialContext(InitialRenderContext context) {
        this.initialContext = context;
    }
}

