/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.api.engine.context.RenderContext;
import org.radeox.engine.context.BaseInitialRenderContext;
import org.radeox.filter.Filter;
import org.radeox.filter.context.FilterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterPipe {
    private static final Logger log = LoggerFactory.getLogger(FilterPipe.class);
    public static final String FIRST_IN_PIPE = "all";
    public static final String LAST_IN_PIPE = "none";
    public static final String[] EMPTY_BEFORE = new String[0];
    public static final String[] NO_REPLACES = new String[0];
    public static final String[] FIRST_BEFORE = new String[]{"all"};
    private InitialRenderContext initialContext;
    private List filterList = new ArrayList();
    private static Object[] noArguments = new Object[0];

    public FilterPipe() {
        this(new BaseInitialRenderContext());
    }

    public FilterPipe(InitialRenderContext context) {
        this.initialContext = context;
    }

    public void init() {
        for (Filter filter : new ArrayList(this.filterList)) {
            String[] replaces = filter.replaces();
            for (int i = 0; i < replaces.length; ++i) {
                String replace = replaces[i];
                this.removeFilter(replace);
            }
        }
    }

    public void removeFilter(String filterClass) {
        Iterator iterator = this.filterList.iterator();
        while (iterator.hasNext()) {
            Filter filter = (Filter)iterator.next();
            if (!filter.getClass().getName().equals(filterClass)) continue;
            iterator.remove();
        }
    }

    public void addFilter(Filter filter) {
        filter.setInitialContext(this.initialContext);
        int minIndex = Integer.MAX_VALUE;
        String[] before = filter.before();
        for (int i = 0; i < before.length; ++i) {
            String s = before[i];
            int index = FilterPipe.index(this.filterList, s);
            if (index >= minIndex) continue;
            minIndex = index;
        }
        if (minIndex == Integer.MAX_VALUE) {
            minIndex = -1;
        }
        if (FilterPipe.contains(filter.before(), FIRST_IN_PIPE)) {
            this.filterList.add(0, filter);
        } else if (minIndex != -1) {
            this.filterList.add(minIndex, filter);
        } else {
            this.filterList.add(filter);
        }
    }

    public int index(String filterName) {
        return FilterPipe.index(this.filterList, filterName);
    }

    public static int index(List list, String filterName) {
        for (int i = 0; i < list.size(); ++i) {
            if (!filterName.equals(list.get(i).getClass().getName())) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(Object[] array, Object value) {
        return Arrays.binarySearch(array, value) != -1;
    }

    public String filter(String input, FilterContext context) {
        String output = input;
        Iterator filterIterator = this.filterList.iterator();
        RenderContext renderContext = context.getRenderContext();
        while (filterIterator.hasNext()) {
            Filter f = (Filter)filterIterator.next();
            try {
                String tmp = f.filter(output, context);
                if (null == tmp) {
                    log.warn("FilterPipe.filter: error while filtering: " + f);
                    continue;
                }
                output = tmp;
            }
            catch (Exception e) {
                log.warn("Filtering exception: " + f, (Throwable)e);
            }
        }
        return output;
    }

    public Filter getFilter(int index) {
        return (Filter)this.filterList.get(index);
    }
}

