/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.filter.CacheFilter;
import org.radeox.filter.Filter;
import org.radeox.filter.FilterPipe;
import org.radeox.filter.context.FilterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParagraphFilter
implements Filter,
CacheFilter {
    private static final Logger log = LoggerFactory.getLogger(ParagraphFilter.class);
    private InitialRenderContext initialContext;
    private String breaksRE;
    private String replaceFirst;
    private String replaceLast;
    private String patternFristRE;
    private String patternLastRE;
    private String replaceAll;

    @Override
    public String filter(String input, FilterContext context) {
        return this.simpleFilter(input, context);
    }

    public String simpleFilter(String input, FilterContext context) {
        log.debug("Paragraph Filter Input " + input);
        Pattern patternBreaks = Pattern.compile(this.breaksRE);
        String[] p = patternBreaks.split(input);
        if (p.length == 1) {
            return input;
        }
        StringBuffer sb = new StringBuffer();
        int nsplits = 0;
        for (int i = 0; i < p.length; ++i) {
            if (nsplits == 0) {
                sb.append(this.replaceFirst);
                ++nsplits;
            } else {
                sb.append(this.replaceAll);
                ++nsplits;
            }
            sb.append(p[i]);
        }
        if (nsplits > 0) {
            sb.append(this.replaceLast);
            ++nsplits;
        }
        String output = sb.toString();
        log.debug("Paragraph Filter Input " + output);
        return output;
    }

    public String complexFilter(String input, FilterContext context) {
        log.debug("Paragraph Filter Input " + input);
        Pattern patternBreaks = Pattern.compile(this.breaksRE);
        String[] p = patternBreaks.split(input);
        if (p.length == 1) {
            return input;
        }
        StringBuffer sb = new StringBuffer();
        int nsplits = 0;
        int ins = p[0].lastIndexOf(">");
        if (ins > 0 && ins + 1 < p[0].length()) {
            sb.append(p[0].substring(0, ins + 1));
            sb.append(this.replaceFirst);
            ++nsplits;
            sb.append(p[0].substring(ins + 1));
        } else {
            sb.append(p[0]);
        }
        for (int i = 1; i < p.length - 1; ++i) {
            if (nsplits == 0) {
                sb.append(this.replaceFirst);
                ++nsplits;
            } else {
                sb.append(this.replaceAll);
                ++nsplits;
            }
            sb.append(p[i]);
        }
        ins = p[p.length - 1].indexOf("<");
        if (ins > 0) {
            if (nsplits == 0) {
                sb.append(this.replaceFirst);
                ++nsplits;
            } else {
                sb.append(this.replaceAll);
                ++nsplits;
            }
            sb.append(p[p.length - 1].substring(0, ins - 1));
            if (nsplits > 0) {
                sb.append(this.replaceLast);
                ++nsplits;
            }
            sb.append(p[p.length - 1].substring(ins - 1));
        } else if (ins == 0) {
            if (nsplits > 0) {
                sb.append(this.replaceLast);
                ++nsplits;
            }
            sb.append(p[p.length - 1]);
        } else {
            if (nsplits > 0) {
                sb.append(this.replaceLast);
                ++nsplits;
            }
            sb.append(p[p.length - 1]);
        }
        String output = sb.toString();
        log.debug("Paragraph Filter Input " + output);
        return output;
    }

    @Override
    public String[] replaces() {
        return FilterPipe.NO_REPLACES;
    }

    @Override
    public String[] before() {
        return FilterPipe.EMPTY_BEFORE;
    }

    @Override
    public void setInitialContext(InitialRenderContext context) {
        this.initialContext = context;
        ResourceBundle outputMessages = this.getOutputBundle();
        ResourceBundle inputMessages = this.getInputBundle();
        this.breaksRE = inputMessages.getString("filter.paragraph.breaks.match");
        this.replaceAll = outputMessages.getString("filter.paragraph.breaks.print");
        this.replaceFirst = outputMessages.getString("filter.paragraph.first.print");
        this.replaceLast = outputMessages.getString("filter.paragraph.last.print");
        this.patternFristRE = inputMessages.getString("filter.paragraph.first.match");
        this.patternLastRE = inputMessages.getString("filter.paragraph.last.match");
    }

    @Override
    public String getDescription() {
        return "Hand Coded paragraph filter";
    }

    protected ResourceBundle getInputBundle() {
        Locale inputLocale = (Locale)this.initialContext.get("RenderContext.input_locale");
        String inputName = (String)this.initialContext.get("RenderContext.input_bundle_name");
        return ResourceBundle.getBundle(inputName, inputLocale);
    }

    protected ResourceBundle getOutputBundle() {
        String outputName = (String)this.initialContext.get("RenderContext.output_bundle_name");
        Locale outputLocale = (Locale)this.initialContext.get("RenderContext.output_locale");
        return ResourceBundle.getBundle(outputName, outputLocale);
    }
}

