/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter.regex;

import java.util.ArrayList;
import java.util.List;
import org.radeox.filter.FilterSupport;
import org.radeox.filter.context.FilterContext;
import org.radeox.regex.Compiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RegexFilter
extends FilterSupport {
    private static final Logger log = LoggerFactory.getLogger(RegexFilter.class);
    protected List pattern = new ArrayList();
    protected List substitute = new ArrayList();
    public static final boolean SINGLELINE = false;
    public static final boolean MULTILINE = true;

    public RegexFilter() {
    }

    public RegexFilter(String regex, String substitute) {
        this();
        this.addRegex(regex, substitute);
    }

    public RegexFilter(String regex, String substitute, boolean multiline) {
        this.addRegex(regex, substitute, multiline);
    }

    public void clearRegex() {
        this.pattern.clear();
        this.substitute.clear();
    }

    public void addRegex(String regex, String substitute) {
        this.addRegex(regex, substitute, true);
    }

    public void addRegex(String regex, String substitute, boolean multiline) {
        try {
            Compiler compiler = Compiler.create();
            compiler.setMultiline(multiline);
            this.pattern.add(compiler.compile(regex));
            this.substitute.add(substitute);
        }
        catch (Exception e) {
            log.warn("bad pattern: " + regex + " -> " + substitute + " " + e);
        }
    }

    @Override
    public abstract String filter(String var1, FilterContext var2);
}

