/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro.table;

import org.radeox.macro.table.Function;
import org.radeox.macro.table.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SumFunction
implements Function {
    private static final Logger log = LoggerFactory.getLogger(SumFunction.class);

    @Override
    public String getName() {
        return "SUM";
    }

    @Override
    public void execute(Table table, int posx, int posy, int startX, int startY, int endX, int endY) {
        float sum = 0.0f;
        boolean floating = false;
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                try {
                    sum += (float)Integer.parseInt((String)table.getXY(x, y));
                    continue;
                }
                catch (Exception e) {
                    try {
                        sum += Float.parseFloat((String)table.getXY(x, y));
                        floating = true;
                        continue;
                    }
                    catch (NumberFormatException e1) {
                        log.debug("SumFunction: unable to parse " + table.getXY(x, y));
                    }
                }
            }
        }
        if (floating) {
            table.setXY(posx, posy, "" + sum);
        } else {
            table.setXY(posx, posy, "" + (int)sum);
        }
    }
}

