/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter;

import java.io.IOException;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.radeox.Messages;
import org.radeox.api.engine.RenderEngine;
import org.radeox.api.engine.WikiRenderEngine;
import org.radeox.filter.context.FilterContext;
import org.radeox.filter.interwiki.InterWiki;
import org.radeox.filter.regex.LocaleRegexTokenFilter;
import org.radeox.regex.MatchResult;
import org.radeox.util.Encoder;
import org.radeox.util.StringBufferWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkTestFilter
extends LocaleRegexTokenFilter {
    private static final Logger log = LoggerFactory.getLogger(LinkTestFilter.class);

    @Override
    protected String getLocaleKey() {
        return "filter.linktest";
    }

    @Override
    public void handleMatch(StringBuffer buffer, MatchResult result, FilterContext context) {
        block30: {
            RenderEngine engine = context.getRenderContext().getRenderEngine();
            if (engine instanceof WikiRenderEngine) {
                WikiRenderEngine wikiEngine = (WikiRenderEngine)engine;
                StringBufferWriter writer = new StringBufferWriter(buffer);
                String name = result.group(1);
                if (name != null) {
                    int atIndex;
                    int colonIndex;
                    if (name.indexOf("http://") != -1) {
                        try {
                            ((Writer)writer).write(Messages.getString("LinkTestFilter.2"));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                    int pipeIndex = name.indexOf(124);
                    String alias = "";
                    if (-1 != pipeIndex) {
                        alias = Encoder.unescape(name.substring(0, pipeIndex).trim());
                        name = name.substring(pipeIndex + 1).trim();
                    }
                    Pattern p = Pattern.compile("(.*)(?<!\\&)\\#(.*)");
                    Matcher m = p.matcher(name);
                    String hash = "";
                    if (m.matches()) {
                        hash = Encoder.unescape(m.group(2));
                        char[] hashChars = hash.toCharArray();
                        int end = 0;
                        for (int i = 0; i < hashChars.length; ++i) {
                            if (!Character.isLetterOrDigit(hashChars[i])) continue;
                            hashChars[end++] = hashChars[i];
                        }
                        if (end > 0) {
                            hash = new String(hashChars, 0, end);
                        }
                        name = m.group(1);
                    }
                    if (-1 != (colonIndex = name.indexOf(58))) {
                        name = name.substring(colonIndex + 1);
                    }
                    if (-1 != (atIndex = name.lastIndexOf(64))) {
                        String extSpace = Encoder.unescape(name.substring(atIndex + 1));
                        InterWiki interWiki = InterWiki.getInstance();
                        if (interWiki.contains(extSpace)) {
                            name = Encoder.unescape(name.substring(0, atIndex));
                            String view = -1 != pipeIndex ? alias : name + "@" + extSpace;
                            try {
                                if (name.indexOf(64) > -1) {
                                    this.addAtSignError(buffer);
                                    break block30;
                                }
                                if (hash.length() > 0) {
                                    interWiki.expand(writer, extSpace, name, view, hash);
                                    break block30;
                                }
                                interWiki.expand(writer, extSpace, name, view);
                            }
                            catch (IOException e) {
                                log.debug("InterWiki " + extSpace + " not found.");
                            }
                        } else {
                            buffer.append("&#91;<span class=\"error\">");
                            buffer.append(result.group(1));
                            buffer.append("?</span>&#93;");
                        }
                    } else if ((name = Encoder.unescape(name)).indexOf(64) > -1) {
                        this.addAtSignError(buffer);
                    } else if (wikiEngine.exists(name) || "".equals(name) && !"".equals(hash)) {
                        if ("".equals(name) && !"".equals(hash)) {
                            name = (String)context.getRenderContext().get("uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject.name");
                        }
                        String view = this.getWikiView(name, hash);
                        if (-1 != pipeIndex) {
                            view = alias;
                        }
                        if (hash.length() > 0) {
                            wikiEngine.appendLink(buffer, name, view, hash);
                        } else {
                            wikiEngine.appendLink(buffer, name, view);
                        }
                    } else if (wikiEngine.showCreate()) {
                        String view = this.getWikiView(name, "");
                        if (-1 != pipeIndex) {
                            view = alias;
                        }
                        wikiEngine.appendCreateLink(buffer, name, view);
                    } else {
                        buffer.append(Encoder.escape(name));
                    }
                } else {
                    buffer.append(Encoder.escape(result.group(0)));
                }
            }
        }
    }

    private void addAtSignError(StringBuffer buffer) {
        buffer.append("<span class=\"error\">");
        buffer.append(Messages.getString("LinkTestFilter.1"));
        buffer.append("</span>");
    }

    protected String getWikiView(String name, String hash) {
        if (!"".equals(hash)) {
            return name + "#" + hash;
        }
        return name;
    }
}

