/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro.table;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.radeox.macro.Repository;
import org.radeox.macro.table.Function;
import org.radeox.macro.table.FunctionRepository;

public class Table {
    private int indexRow = 0;
    private int indexCol = 0;
    private List rows;
    private List currentRow;
    private String currentCell = "";
    private List functionOccurences;
    private Repository functions;
    private HashMap tableAttributes = new HashMap();

    public Table() {
        this.rows = new ArrayList(10);
        this.currentRow = new ArrayList(10);
        this.functions = FunctionRepository.getInstance();
        this.tableAttributes.put("border", "0");
        this.tableAttributes.put("cellspacing", "0");
        this.tableAttributes.put("cellpadding", "0");
        this.tableAttributes.put("class", "listHier lines");
    }

    public void setAttribute(String attributeName, String attributeValue) {
        this.tableAttributes.put(attributeName, attributeValue);
    }

    private void addFunction(Function function) {
        this.functions.put(function.getName().toLowerCase(), function);
    }

    public Object getXY(int x, int y) {
        return ((List)this.rows.get(y)).get(x);
    }

    public void setXY(int x, int y, Object content) {
        ((List)this.rows.get(y)).set(x, content);
    }

    public void addCell(String content) {
        if (!"".equals(this.currentCell)) {
            this.newCell();
        }
        this.addText(content);
    }

    public void newCell() {
        this.currentCell = this.currentCell.trim();
        if (this.currentCell.startsWith("=")) {
            if (null == this.functionOccurences) {
                this.functionOccurences = new ArrayList();
            }
            this.functionOccurences.add(new int[]{this.indexCol, this.indexRow});
        }
        this.currentRow.add(this.currentCell);
        ++this.indexCol;
        this.currentCell = "";
    }

    public void addText(String content) {
        this.currentCell = this.currentCell + content;
    }

    public void newRow() {
        this.newCell();
        this.rows.add(this.currentRow);
        ++this.indexRow;
        this.currentRow = new ArrayList(this.indexCol);
        this.indexCol = 0;
    }

    public void calc() {
        if (null != this.functionOccurences) {
            for (int[] position : this.functionOccurences) {
                int tmp;
                String functionString = ((String)this.getXY(position[0], position[1])).trim();
                String name = functionString.substring(1, functionString.indexOf("(")).trim().toLowerCase();
                String range = functionString.substring(functionString.indexOf("(") + 1, functionString.indexOf(")"));
                int colon = range.indexOf(":");
                String start = range.substring(0, colon).trim();
                String end = range.substring(colon + 1).trim();
                int startX = start.charAt(0) - 65;
                int startY = Integer.parseInt(start.substring(1)) - 1;
                int endX = end.charAt(0) - 65;
                int endY = Integer.parseInt(end.substring(1)) - 1;
                if (startX > endX) {
                    tmp = startX;
                    startX = endX;
                    endX = tmp;
                }
                if (startY > endY) {
                    tmp = startY;
                    startY = endY;
                    endY = tmp;
                }
                if (!this.functions.containsKey(name)) continue;
                Function function = (Function)this.functions.get(name);
                function.execute(this, position[0], position[1], startX, startY, endX, endY);
            }
        }
    }

    public Writer appendTo(Writer writer) throws IOException {
        writer.write("<table");
        Set keySet = this.tableAttributes.keySet();
        Object[] toSort = new String[keySet.size()];
        int i = 0;
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            toSort[i] = (String)it.next();
            ++i;
        }
        Arrays.sort(toSort);
        for (i = 0; i < toSort.length; ++i) {
            Object key = toSort[i];
            writer.write(32);
            writer.write((String)key);
            writer.write("=\"");
            writer.write((String)this.tableAttributes.get(key));
            writer.write("\"");
        }
        writer.write(">");
        List[] outputRows = this.rows.toArray(new List[this.rows.size()]);
        int rowSize = outputRows.length;
        boolean odd = true;
        for (int i2 = 0; i2 < rowSize; ++i2) {
            writer.write("<tr");
            if (i2 == 0) {
                writer.write(">");
            } else if (odd) {
                writer.write(" class=\"table-odd\">");
                odd = false;
            } else {
                writer.write(" class=\"table-even\">");
                odd = true;
            }
            String[] outputCols = outputRows[i2].toArray(new String[outputRows[i2].size()]);
            int colSize = outputCols.length;
            for (int j = 0; j < colSize; ++j) {
                writer.write(i2 == 0 ? "<th scope=\"col\">" : "<td>");
                if (outputCols[j] == null || outputCols[j].trim().length() == 0) {
                    writer.write("&#160;");
                } else {
                    writer.write(outputCols[j]);
                }
                writer.write(i2 == 0 ? "</th>" : "</td>");
            }
            writer.write("</tr>");
        }
        writer.write("</table>");
        return writer;
    }
}

