/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro.table;

import org.radeox.macro.table.Function;
import org.radeox.macro.table.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinFunction
implements Function {
    private static final Logger log = LoggerFactory.getLogger(MinFunction.class);

    @Override
    public String getName() {
        return "MIN";
    }

    @Override
    public void execute(Table table, int posx, int posy, int startX, int startY, int endX, int endY) {
        float min = Float.MAX_VALUE;
        boolean floating = false;
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                float value = 0.0f;
                try {
                    value += (float)Integer.parseInt((String)table.getXY(x, y));
                }
                catch (Exception e) {
                    try {
                        value += Float.parseFloat((String)table.getXY(x, y));
                        floating = true;
                    }
                    catch (NumberFormatException e1) {
                        log.debug("SumFunction: unable to parse " + table.getXY(x, y));
                    }
                }
                if (!(min > value)) continue;
                min = value;
            }
        }
        if (floating) {
            table.setXY(posx, posy, "" + min);
        } else {
            table.setXY(posx, posy, "" + (int)min);
        }
    }
}

