/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro.table;

import java.util.StringTokenizer;
import org.radeox.macro.table.Table;

public class TableBuilder {
    private static final String BAR = "|";
    private static final String NL = "\n";
    private static final String OPEN_LINK = "[";
    private static final String CLOSE_LINK = "]";
    private static final String TOKENS_STRING = "|\n[]";
    private Table table = new Table();
    private StringTokenizer tokenizer;
    private String[] token;

    private TableBuilder(String content) {
        this.tokenizer = new StringTokenizer(content, TOKENS_STRING, true);
        this.token = new String[5];
        for (int i = 0; i < this.token.length; ++i) {
            this.token[i] = this.tokenizer.hasMoreTokens() ? this.tokenizer.nextToken() : null;
        }
    }

    public static Table build(String content) {
        TableBuilder builder = new TableBuilder(content);
        builder.build();
        return builder.getTable();
    }

    public void build() {
        String lastToken = null;
        while (this.token[0] != null) {
            if (NL.equals(this.token[0])) {
                if (null != lastToken) {
                    this.table.newRow();
                }
            } else if (BAR.equals(this.token[0])) {
                this.table.newCell();
            } else if (OPEN_LINK.equals(this.token[0])) {
                if (TableBuilder.isText(this.token[1]) && TableBuilder.isBar(this.token[2]) && TableBuilder.isText(this.token[3]) && TableBuilder.isCloseLink(this.token[4])) {
                    for (int i = 0; i < 4; ++i) {
                        this.table.addText(this.token[0]);
                        this.step();
                    }
                    this.table.addText(this.token[0]);
                } else {
                    this.table.addText(this.token[0]);
                }
            } else {
                this.table.addText(this.token[0]);
            }
            lastToken = this.token[0];
            this.step();
        }
        if (!NL.equals(lastToken)) {
            this.table.newRow();
        }
    }

    private void step() {
        for (int i = 1; i < this.token.length; ++i) {
            this.token[i - 1] = this.token[i];
        }
        this.token[this.token.length - 1] = this.tokenizer.hasMoreTokens() ? this.tokenizer.nextToken() : null;
    }

    private static boolean isBar(String token) {
        return BAR.equals(token);
    }

    private static boolean isOpenLink(String token) {
        return OPEN_LINK.equals(token);
    }

    private static boolean isCloseLink(String token) {
        return CLOSE_LINK.equals(token);
    }

    private static boolean isNewLine(String token) {
        return NL.equals(token);
    }

    private static boolean isText(String token) {
        for (int i = 0; i < TOKENS_STRING.length(); ++i) {
            if (!("" + TOKENS_STRING.charAt(i)).equals(token)) continue;
            return false;
        }
        return true;
    }

    public Table getTable() {
        return this.table;
    }
}

