/*
 * Decompiled with CFR 0.152.
 */
package org.radeox;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.radeox.api.engine.RenderEngine;
import org.radeox.engine.BaseRenderEngine;
import org.radeox.util.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineManager {
    private static final Logger log = LoggerFactory.getLogger(EngineManager.class);
    public static final String DEFAULT = "radeox";
    private static Map availableEngines = new HashMap();

    public static synchronized void registerEngine(RenderEngine engine) {
        if (null == availableEngines) {
            availableEngines = new HashMap();
        }
        availableEngines.put(engine.getName(), engine);
    }

    public static synchronized RenderEngine getInstance(String name) {
        if (null == availableEngines) {
            availableEngines = new HashMap();
        }
        return (RenderEngine)availableEngines.get(name);
    }

    public static synchronized RenderEngine getInstance() {
        if (null == availableEngines) {
            availableEngines = new HashMap();
        }
        if (!availableEngines.containsKey(DEFAULT)) {
            BaseRenderEngine engine = new BaseRenderEngine();
            availableEngines.put(engine.getName(), engine);
        }
        return (RenderEngine)availableEngines.get(DEFAULT);
    }

    public static String getVersion() {
        return "0.5.1";
    }

    static {
        Iterator iterator = Service.providers(RenderEngine.class);
        while (iterator.hasNext()) {
            try {
                RenderEngine engine = (RenderEngine)iterator.next();
                EngineManager.registerEngine(engine);
                log.debug("Loaded RenderEngine: " + engine.getClass().getName());
            }
            catch (Exception e) {
                log.warn("EngineManager: unable to load RenderEngine", (Throwable)e);
            }
        }
    }
}

