/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter.regex;

import java.util.Locale;
import java.util.ResourceBundle;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.filter.regex.RegexTokenFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocaleRegexTokenFilter
extends RegexTokenFilter {
    private static final Logger log = LoggerFactory.getLogger(LocaleRegexTokenFilter.class);
    protected ResourceBundle inputMessages;
    protected ResourceBundle outputMessages;

    protected boolean isSingleLine() {
        return false;
    }

    protected ResourceBundle getInputBundle() {
        Locale inputLocale = (Locale)this.initialContext.get("RenderContext.input_locale");
        String inputName = (String)this.initialContext.get("RenderContext.input_bundle_name");
        return ResourceBundle.getBundle(inputName, inputLocale);
    }

    protected ResourceBundle getOutputBundle() {
        Locale outputLocale = (Locale)this.initialContext.get("RenderContext.output_locale");
        String outputName = (String)this.initialContext.get("RenderContext.output_bundle_name");
        return ResourceBundle.getBundle(outputName, outputLocale);
    }

    @Override
    public void setInitialContext(InitialRenderContext context) {
        super.setInitialContext(context);
        this.clearRegex();
        this.outputMessages = this.getOutputBundle();
        this.inputMessages = this.getInputBundle();
        String match = this.inputMessages.getString(this.getLocaleKey() + ".match");
        this.addRegex(match, "", !this.isSingleLine());
    }

    protected abstract String getLocaleKey();
}

