/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro;

import java.io.IOException;
import java.io.Writer;
import org.radeox.Messages;
import org.radeox.api.macro.MacroParameter;
import org.radeox.macro.BaseLocaleMacro;
import org.radeox.macro.api.ApiDoc;

public class ApiMacro
extends BaseLocaleMacro {
    private String[] paramDescription = new String[]{Messages.getString("ApiMacro.0"), Messages.getString("ApiMacro.1")};

    @Override
    public String[] getParamDescription() {
        return this.paramDescription;
    }

    @Override
    public String getLocaleKey() {
        return "macro.api";
    }

    @Override
    public void execute(Writer writer, MacroParameter params) throws IllegalArgumentException, IOException {
        String mode;
        String klass;
        if (params.getLength() == 1) {
            klass = params.get("0");
            int index = klass.indexOf("@");
            if (index > 0) {
                mode = klass.substring(index + 1);
                klass = klass.substring(0, index);
            } else {
                mode = "java";
            }
        } else if (params.getLength() == 2) {
            mode = params.get("1").toLowerCase();
            klass = params.get("0");
        } else {
            throw new IllegalArgumentException(Messages.getString("ApiMacro.8"));
        }
        ApiDoc.getInstance().expand(writer, klass, mode);
    }
}

