/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro;

import java.io.IOException;
import java.io.Writer;
import org.radeox.Messages;
import org.radeox.api.macro.MacroParameter;
import org.radeox.macro.BaseLocaleMacro;
import org.radeox.util.Encoder;

public class RfcMacro
extends BaseLocaleMacro {
    @Override
    public String getLocaleKey() {
        return "macro.rfc";
    }

    @Override
    public void execute(Writer writer, MacroParameter params) throws IllegalArgumentException, IOException {
        String number = params.get("0");
        try {
            Integer.parseInt(number);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(Messages.getString("RfcMacro.3"));
        }
        if (params.getLength() == 1) {
            String view = "RFC" + number;
            this.appendRfc(writer, number, view);
            return;
        }
        if (params.getLength() != 2) {
            throw new IllegalArgumentException(Messages.getString("RfcMacro.3"));
        }
        String view = params.get(1);
        this.appendRfc(writer, number, view);
    }

    public void appendRfc(Writer writer, String number, String view) throws IOException, IllegalArgumentException {
        writer.write("<a href=\"https://www.rfc-editor.org/info/rfc");
        writer.write(number);
        writer.write("\">");
        writer.write(Encoder.escape(view));
        writer.write("</a>");
    }
}

