/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.util;

import java.util.HashMap;
import java.util.Map;
import org.radeox.regex.Compiler;
import org.radeox.regex.MatchResult;
import org.radeox.regex.Matcher;
import org.radeox.regex.Pattern;
import org.radeox.regex.Substitution;

public class Encoder {
    public static final char HIGHEST_CHARACTER = '~';
    public static final char[][] specialChars = new char[127][];
    private static final Map<String, String> ESCAPED_CHARS;

    public static String escape(String toEscape) {
        char[] chars = toEscape.toCharArray();
        int lastEscapedBefore = 0;
        StringBuffer escapedString = null;
        for (int i = 0; i < chars.length; ++i) {
            char[] escapedPortion;
            if (chars[i] > '~' || (escapedPortion = specialChars[chars[i]]) == null) continue;
            if (lastEscapedBefore == 0) {
                escapedString = new StringBuffer(chars.length + 5);
            }
            if (lastEscapedBefore < i) {
                escapedString.append(chars, lastEscapedBefore, i - lastEscapedBefore);
            }
            lastEscapedBefore = i + 1;
            escapedString.append(escapedPortion);
        }
        if (lastEscapedBefore == 0) {
            return toEscape;
        }
        if (lastEscapedBefore < chars.length) {
            escapedString.append(chars, lastEscapedBefore, chars.length - lastEscapedBefore);
        }
        return escapedString.toString();
    }

    public static String unescape(String str) {
        StringBuffer result = new StringBuffer();
        Compiler compiler = Compiler.create();
        Pattern entityPattern = compiler.compile("&(#?[0-9a-fA-F]+|gt|lt|amp);");
        Matcher matcher = Matcher.create(str, entityPattern);
        result.append(matcher.substitute(new Substitution(){

            @Override
            public void handleMatch(StringBuffer buffer, MatchResult result) {
                String m = result.group(1);
                if ("amp".equals(m)) {
                    buffer.append("&");
                } else if ("gt".equals(m)) {
                    buffer.append(">");
                } else if ("lt".equals(m)) {
                    buffer.append("<");
                } else {
                    buffer.append(Encoder.toChar(result.group(1)));
                }
            }
        }));
        return result.toString();
    }

    public static String toEntity(int c) {
        char[] escapedPortion;
        if (c <= 126 && (escapedPortion = specialChars[c]) != null) {
            return new String(escapedPortion);
        }
        return "&#" + c + ";";
    }

    public static char toChar(String number) {
        return (char)Integer.decode(number.substring(1)).intValue();
    }

    static {
        Encoder.specialChars[62] = "&gt;".toCharArray();
        Encoder.specialChars[60] = "&lt;".toCharArray();
        Encoder.specialChars[38] = "&amp;".toCharArray();
        Encoder.specialChars[34] = "&#34;".toCharArray();
        Encoder.specialChars[39] = "&#39;".toCharArray();
        Encoder.specialChars[91] = "&#91;".toCharArray();
        Encoder.specialChars[93] = "&#93;".toCharArray();
        Encoder.specialChars[95] = "&#95;".toCharArray();
        Encoder.specialChars[45] = "&#45;".toCharArray();
        Encoder.specialChars[126] = "&#126;".toCharArray();
        ESCAPED_CHARS = new HashMap<String, String>();
        ESCAPED_CHARS.put("&gt;", ">");
        ESCAPED_CHARS.put("&lt;", "<");
        ESCAPED_CHARS.put("&amp;", "&");
        ESCAPED_CHARS.put("&quot;", "\"");
        ESCAPED_CHARS.put("&#39;", "'");
        ESCAPED_CHARS.put("&#91;", "[");
        ESCAPED_CHARS.put("&#93;", "]");
        ESCAPED_CHARS.put("&#95;", "_");
        ESCAPED_CHARS.put("&#45;", "-");
        ESCAPED_CHARS.put("&#126;", "~");
    }
}

