/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.rights.impl;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.id.cover.IdManager;
import org.sakaiproject.rights.api.Copyright;
import org.sakaiproject.rights.api.CreativeCommonsLicense;
import org.sakaiproject.rights.api.RightsAssignment;
import org.sakaiproject.rights.api.RightsPolicy;
import org.sakaiproject.rights.api.RightsService;
import org.sakaiproject.rights.api.SiteRightsPolicy;
import org.sakaiproject.rights.api.UserRightsPolicy;
import org.sakaiproject.rights.util.RightsException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BaseRightsService
implements RightsService {
    private static Log M_log = LogFactory.getLog(BaseRightsService.class);
    protected Storage m_storage = null;

    public RightsAssignment addRightsAssignment(String entityRef) {
        return this.m_storage.newRightsAssignment(entityRef);
    }

    public SiteRightsPolicy addSiteRightsPolicy(String context) {
        return null;
    }

    public UserRightsPolicy addUserRightsPolicy(String context, String userId) {
        return null;
    }

    public void destroy() {
        this.m_storage.close();
        this.m_storage = null;
        M_log.info((Object)"destroy()");
    }

    public RightsAssignment getRightsAssignment(String entityRef) throws IdUnusedException {
        return this.m_storage.getRightsAssignment(entityRef);
    }

    public SiteRightsPolicy getSiteRightsPolicy(String context) {
        return null;
    }

    public UserRightsPolicy getUserRightsPolicy(String context, String userId) {
        return null;
    }

    public void init() {
        try {
            this.m_storage = this.newStorage();
            this.m_storage.open();
            M_log.info((Object)"init()");
        }
        catch (Throwable t) {
            M_log.warn((Object)"init(): ", t);
        }
    }

    protected abstract Storage newStorage();

    public void save(RightsAssignment rights) {
        this.m_storage.save(rights);
    }

    public void save(RightsPolicy policy) {
        this.m_storage.save(policy);
    }

    public void setRightsAssignment(String entityRef, RightsAssignment rights) {
    }

    public static interface Storage {
        public void close();

        public Copyright getCopyright(String var1) throws IdUnusedException;

        public CreativeCommonsLicense getLicense(String var1) throws IdUnusedException;

        public RightsAssignment getRightsAssignment(String var1) throws IdUnusedException;

        public RightsPolicy getRightsPolicy(String var1, String var2) throws IdUnusedException;

        public Copyright newCopyright(String var1);

        public CreativeCommonsLicense newLicense(String var1);

        public RightsAssignment newRightsAssignment(String var1);

        public RightsPolicy newRightsPolicy(String var1, String var2);

        public void open();

        public void remove(Copyright var1);

        public void remove(CreativeCommonsLicense var1);

        public void remove(RightsAssignment var1);

        public void remove(RightsPolicy var1);

        public String save(Copyright var1);

        public String save(CreativeCommonsLicense var1);

        public String save(RightsAssignment var1);

        public String save(RightsPolicy var1);
    }

    public static class BasicRightsAssignment
    implements RightsAssignment {
        protected Map<String, CreativeCommonsLicense> m_licenses = new Hashtable<String, CreativeCommonsLicense>();
        protected Copyright m_copyright;
        protected String m_entityRef = null;
        protected String m_id = IdManager.createUuid();
        protected boolean m_copyrightAlert = false;

        public BasicRightsAssignment(String entityRef) {
            this.m_entityRef = entityRef;
        }

        public void addLicense(CreativeCommonsLicense license) {
            if (this.m_licenses == null) {
                this.m_licenses = new Hashtable<String, CreativeCommonsLicense>();
            }
            this.m_licenses.put(license.getIdentifier(), license);
        }

        public int countLicenses() {
            return this.m_licenses.size();
        }

        public Copyright getCopyright() {
            return this.m_copyright;
        }

        public String getEntityRef() {
            return this.m_entityRef;
        }

        public Collection<CreativeCommonsLicense> getLicenses() {
            return this.m_licenses.values();
        }

        public String getRightsId() {
            return this.m_id;
        }

        public boolean hasCopyright() {
            return this.m_copyright != null;
        }

        public boolean hasCopyrightAlert() {
            return this.m_copyrightAlert;
        }

        public boolean hasLicense() {
            return this.m_licenses != null && !this.m_licenses.isEmpty();
        }

        public void setCopyright(Copyright copyright) {
            this.m_copyright = copyright;
        }

        public void setLicenses(Collection<CreativeCommonsLicense> licenses) {
        }

        public Element toXml(Document doc, Stack<Object> stack) {
            return null;
        }
    }

    public static class BasicCreativeCommonsLicense
    implements CreativeCommonsLicense {
        protected String m_id;
        protected Set<CreativeCommonsLicense.Permission> m_permissions = new TreeSet<CreativeCommonsLicense.Permission>();
        protected Set<CreativeCommonsLicense.Prohibition> m_prohibitions = new TreeSet<CreativeCommonsLicense.Prohibition>();
        protected Set<CreativeCommonsLicense.Requirement> m_requirements = new TreeSet<CreativeCommonsLicense.Requirement>();

        public void addPermission(CreativeCommonsLicense.Permission permission) {
            if (this.m_permissions == null) {
                this.m_permissions = new TreeSet<CreativeCommonsLicense.Permission>();
            }
            this.m_permissions.add(permission);
        }

        public void addPermission(String permission) throws RightsException {
            CreativeCommonsLicense.Permission p = CreativeCommonsLicense.Permission.fromString((String)permission);
            if (p == null) {
                throw new RightsException();
            }
            this.addPermission(p);
        }

        public void addProhibition(CreativeCommonsLicense.Prohibition prohibition) {
            if (this.m_prohibitions == null) {
                this.m_prohibitions = new TreeSet<CreativeCommonsLicense.Prohibition>();
            }
            this.m_prohibitions.add(prohibition);
        }

        public void addProhibition(String prohibition) throws RightsException {
            CreativeCommonsLicense.Prohibition p = CreativeCommonsLicense.Prohibition.fromString((String)prohibition);
            if (p == null) {
                throw new RightsException();
            }
            this.addProhibition(p);
        }

        public void addRequirement(CreativeCommonsLicense.Requirement requirement) {
            if (this.m_requirements == null) {
                this.m_requirements = new TreeSet<CreativeCommonsLicense.Requirement>();
            }
            this.m_requirements.add(requirement);
        }

        public void addRequirement(String requirement) throws RightsException {
            CreativeCommonsLicense.Requirement r = CreativeCommonsLicense.Requirement.fromString((String)requirement);
            if (r == null) {
                throw new RightsException();
            }
            this.addRequirement(r);
        }

        public String getIdentifier() {
            return null;
        }

        public Collection<CreativeCommonsLicense.Permission> getPermissions() {
            return this.m_permissions;
        }

        public Collection<CreativeCommonsLicense.Prohibition> getProhibitions() {
            return this.m_prohibitions;
        }

        public Collection<CreativeCommonsLicense.Requirement> getRequirements() {
            return this.m_requirements;
        }

        public String getUri() {
            return null;
        }

        public boolean hasPermissions() {
            return this.m_permissions != null && !this.m_permissions.isEmpty();
        }

        public boolean hasProhibitions() {
            return this.m_prohibitions != null && !this.m_prohibitions.isEmpty();
        }

        public boolean hasRequirements() {
            return this.m_requirements != null && !this.m_requirements.isEmpty();
        }

        public void removePermission(String permission) {
            CreativeCommonsLicense.Permission p = CreativeCommonsLicense.Permission.fromString((String)permission);
            if (p != null) {
                this.m_permissions.remove(p);
            }
        }

        public void removeProhibitions(Collection<Object> prohibitions) {
            if (prohibitions != null) {
                for (Object obj : prohibitions) {
                    CreativeCommonsLicense.Prohibition p = null;
                    if (obj instanceof CreativeCommonsLicense.Prohibition) {
                        p = (CreativeCommonsLicense.Prohibition)obj;
                    } else if (obj instanceof String) {
                        p = CreativeCommonsLicense.Prohibition.fromString((String)((String)obj));
                    }
                    if (p == null) continue;
                    this.m_prohibitions.remove(p);
                }
            }
        }

        public void removeRequirements(Collection<Object> requirements) {
            if (this.m_requirements == null) {
                this.m_requirements = new TreeSet<CreativeCommonsLicense.Requirement>();
            }
            this.m_requirements.clear();
            if (requirements != null) {
                for (Object obj : requirements) {
                    CreativeCommonsLicense.Requirement r = null;
                    if (obj instanceof CreativeCommonsLicense.Requirement) {
                        r = (CreativeCommonsLicense.Requirement)obj;
                    } else if (obj instanceof String) {
                        r = CreativeCommonsLicense.Requirement.fromString((String)((String)obj));
                    }
                    if (r == null) continue;
                    this.m_requirements.remove(r);
                }
            }
        }

        public void setPermissions(Collection<Object> permissions) {
            if (this.m_permissions == null) {
                this.m_permissions = new TreeSet<CreativeCommonsLicense.Permission>();
            }
            this.m_permissions.clear();
            if (permissions != null) {
                for (Object obj : permissions) {
                    CreativeCommonsLicense.Permission p = null;
                    if (obj instanceof CreativeCommonsLicense.Permission) {
                        p = (CreativeCommonsLicense.Permission)obj;
                    } else if (obj instanceof String) {
                        p = CreativeCommonsLicense.Permission.fromString((String)((String)obj));
                    }
                    if (p == null) continue;
                    this.m_permissions.add(p);
                }
            }
        }

        public void setProhibitions(Collection<Object> prohibitions) {
            if (this.m_prohibitions == null) {
                this.m_prohibitions = new TreeSet<CreativeCommonsLicense.Prohibition>();
            }
            this.m_prohibitions.clear();
            if (prohibitions != null) {
                for (Object obj : prohibitions) {
                    CreativeCommonsLicense.Prohibition p = null;
                    if (obj instanceof CreativeCommonsLicense.Prohibition) {
                        p = (CreativeCommonsLicense.Prohibition)obj;
                    } else if (obj instanceof String) {
                        p = CreativeCommonsLicense.Prohibition.fromString((String)((String)obj));
                    }
                    if (p == null) continue;
                    this.m_prohibitions.add(p);
                }
            }
        }

        public void setRequirements(Collection<Object> requirements) {
        }

        public Element toXml(Document doc, Stack<Object> stack) {
            return null;
        }
    }

    public static class BasicCopyright
    implements Copyright {
        protected String m_id;
        protected String m_entityRef;
        protected String m_year;
        protected String m_owner;

        public BasicCopyright(String entityRef) {
            this.m_entityRef = entityRef;
        }

        public BasicCopyright(String entityRef, String year, String owner) {
            this.m_entityRef = entityRef;
            this.m_year = year;
            this.m_owner = owner;
        }

        public String getCopyrightId() {
            return this.m_id;
        }

        public String getEntityRef() {
            return this.m_entityRef;
        }

        public String getOwner() {
            return this.m_owner;
        }

        public String getYear() {
            return this.m_year;
        }

        public void setOwner(String owner) {
            this.m_owner = owner;
        }

        public void setYear(String year) {
            this.m_year = year;
        }

        public Element toXml(Document doc, Stack<Object> stack) {
            return null;
        }
    }
}

