/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.rights.impl;

import java.util.Hashtable;
import java.util.Map;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.rights.api.Copyright;
import org.sakaiproject.rights.api.CreativeCommonsLicense;
import org.sakaiproject.rights.api.RightsAssignment;
import org.sakaiproject.rights.api.RightsPolicy;
import org.sakaiproject.rights.impl.BaseRightsService;

public class BasicRightsService
extends BaseRightsService {
    @Override
    public void destroy() {
    }

    @Override
    public void init() {
    }

    @Override
    protected BaseRightsService.Storage newStorage() {
        return new BasicStorage();
    }

    protected static class BasicStorage
    implements BaseRightsService.Storage {
        protected Map<String, Copyright> m_copyrights = new Hashtable<String, Copyright>();
        protected Map<String, CreativeCommonsLicense> m_licenses = new Hashtable<String, CreativeCommonsLicense>();
        protected Map<String, RightsAssignment> m_rightsAssignments = new Hashtable<String, RightsAssignment>();

        @Override
        public void close() {
            if (this.m_copyrights != null) {
                this.m_copyrights.clear();
                this.m_copyrights = null;
            }
            if (this.m_licenses != null) {
                this.m_licenses.clear();
                this.m_licenses = null;
            }
            if (this.m_rightsAssignments != null) {
                this.m_rightsAssignments.clear();
                this.m_rightsAssignments = null;
            }
        }

        @Override
        public Copyright getCopyright(String copyrightId) throws IdUnusedException {
            Copyright copyright = this.m_copyrights.get(copyrightId);
            if (copyright == null) {
                throw new IdUnusedException(copyrightId);
            }
            return copyright;
        }

        @Override
        public CreativeCommonsLicense getLicense(String licenseId) throws IdUnusedException {
            CreativeCommonsLicense license = this.m_licenses.get(licenseId);
            if (license == null) {
                throw new IdUnusedException(licenseId);
            }
            return license;
        }

        @Override
        public RightsAssignment getRightsAssignment(String entityRef) throws IdUnusedException {
            RightsAssignment rights = this.m_rightsAssignments.get(entityRef);
            if (rights == null) {
                throw new IdUnusedException(entityRef);
            }
            return rights;
        }

        @Override
        public RightsPolicy getRightsPolicy(String context, String userId) throws IdUnusedException {
            return null;
        }

        @Override
        public Copyright newCopyright(String rightsId) {
            return new BaseRightsService.BasicCopyright(rightsId);
        }

        @Override
        public CreativeCommonsLicense newLicense(String rightsId) {
            return null;
        }

        @Override
        public RightsAssignment newRightsAssignment(String entityRef) {
            return new BaseRightsService.BasicRightsAssignment(entityRef);
        }

        @Override
        public RightsPolicy newRightsPolicy(String context, String userId) {
            return null;
        }

        @Override
        public void open() {
        }

        @Override
        public void remove(Copyright copyright) {
        }

        @Override
        public void remove(CreativeCommonsLicense license) {
        }

        @Override
        public void remove(RightsAssignment rights) {
        }

        @Override
        public void remove(RightsPolicy policy) {
        }

        @Override
        public String save(Copyright copyright) {
            return null;
        }

        @Override
        public String save(CreativeCommonsLicense license) {
            return null;
        }

        @Override
        public String save(RightsAssignment rights) {
            return null;
        }

        @Override
        public String save(RightsPolicy policy) {
            return null;
        }
    }
}

