/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.service.exception;

import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.service.exception.PermissionException;

public class ReadPermissionException
extends PermissionException {
    private static final long serialVersionUID = -3744459824034953929L;
    private String user;
    private RWikiObject rwikiObject;
    private String realm;

    public ReadPermissionException(String user, RWikiObject rwikiObject) {
        super("User: " + user + " cannot read RWikiObject " + rwikiObject);
        this.user = user;
        this.rwikiObject = rwikiObject;
        this.realm = rwikiObject.getRealm();
    }

    public ReadPermissionException(String user, RWikiObject rwikiObject, Throwable cause) {
        super("User: " + user + " cannot read RWikiObject " + rwikiObject, cause);
        this.user = user;
        this.rwikiObject = rwikiObject;
        this.realm = rwikiObject.getRealm();
    }

    public ReadPermissionException(String user, String realm) {
        super("User: " + user + " is not permitted to read in realm " + realm);
        this.user = user;
        this.realm = realm;
        this.rwikiObject = null;
    }

    public RWikiObject getRWikiObject() {
        return this.rwikiObject;
    }

    public void setRWikiObject(RWikiObject rwikiObject) {
        this.rwikiObject = rwikiObject;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }
}

