/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.service.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.xml.serializer.DOMSerializer;
import org.apache.xml.serializer.ToXMLSAXHandler;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.cover.ContentHostingService;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.cover.EntityManager;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.cam.caret.sakai.rwiki.component.service.impl.XSLTEntityHandler;

public class BaseFOPSerializer
extends ToXMLSAXHandler
implements ContentHandler {
    private static final Log logger = LogFactory.getLog(BaseFOPSerializer.class);
    private static final String configfile = "/uk/ac/cam/caret/sakai/rwiki/component/service/impl/fop.cfg.xml";
    private Properties outputFormat = null;
    private Writer writer = null;
    private OutputStream outputStream = null;
    private ContentHandler contentHandler = null;
    private Fop fop = null;
    protected String mimeType = "application/pdf";

    public void setOutputStream(OutputStream arg0) {
        this.outputStream = arg0;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setWriter(Writer arg0) {
        this.writer = arg0;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setOutputFormat(Properties arg0) {
        this.outputFormat = arg0;
    }

    public Properties getOutputFormat() {
        return this.outputFormat;
    }

    public ContentHandler asContentHandler() throws IOException {
        DefaultHandler dh;
        if (this.fop == null) {
            InputStream stream = null;
            try {
                DefaultConfigurationBuilder cfgBuild = new DefaultConfigurationBuilder();
                stream = this.getClass().getResourceAsStream(configfile);
                Configuration cfg = cfgBuild.build(stream);
                final FopFactory ff = FopFactory.newInstance();
                ff.setUserConfig(cfg);
                FOUserAgent userAgent = ff.newFOUserAgent();
                userAgent.setURIResolver(new URIResolver(){

                    @Override
                    public Source resolve(String href, String base) throws TransformerException {
                        StreamSource source = null;
                        try {
                            logger.info((Object)("Resolving " + href + " from " + base));
                            HttpServletRequest request = XSLTEntityHandler.getCurrentRequest();
                            if (request != null && href.startsWith("/access")) {
                                try {
                                    String path = href.substring("/access".length());
                                    Reference ref = EntityManager.newReference((String)path);
                                    ContentResource resource = ContentHostingService.getResource((String)ref.getId());
                                    return new StreamSource(resource.streamContent());
                                }
                                catch (Exception ex) {
                                    URI uri = new URI(base);
                                    String content = uri.resolve(href).toString();
                                    source = new StreamSource(content);
                                }
                            } else {
                                if (base == null) {
                                    return ff.resolveURI(href, base);
                                }
                                URI uri = new URI(base);
                                String content = uri.resolve(href).toString();
                                source = new StreamSource(content);
                            }
                        }
                        catch (Exception ex) {
                            throw new TransformerException("Failed to get " + href, ex);
                        }
                        return source;
                    }
                });
                userAgent.setBaseURL(ServerConfigurationService.getString((String)"serverUrl"));
                this.fop = ff.newFop(this.mimeType, userAgent, this.outputStream);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to create Handler ", (Throwable)e);
                throw new IOException("Failed to create " + this.mimeType + " Serializer: " + e.getMessage());
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        try {
            dh = this.fop.getDefaultHandler();
        }
        catch (FOPException e) {
            logger.error((Object)"Failed to get FOP Handler ", (Throwable)e);
            throw new RuntimeException("Failed to get FOP Handler ", e);
        }
        return dh;
    }

    public DOMSerializer asDOMSerializer() {
        return null;
    }

    public boolean reset() {
        this.fop = null;
        this.outputFormat = null;
        this.writer = null;
        this.outputStream = null;
        return false;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.initContentHandler();
        this.contentHandler.characters(ch, start, length);
    }

    private void initContentHandler() throws SAXException {
        if (this.contentHandler == null) {
            try {
                this.contentHandler = this.asContentHandler();
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.initContentHandler();
        this.contentHandler.endDocument();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.initContentHandler();
        this.contentHandler.endElement(uri, localName, qName);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.initContentHandler();
        this.contentHandler.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.initContentHandler();
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.initContentHandler();
        this.contentHandler.processingInstruction(target, data);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        try {
            this.initContentHandler();
        }
        catch (SAXException e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        this.contentHandler.setDocumentLocator(locator);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.initContentHandler();
        this.contentHandler.skippedEntity(name);
    }

    @Override
    public void startDocument() throws SAXException {
        this.initContentHandler();
        this.contentHandler.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.initContentHandler();
        this.contentHandler.startElement(uri, localName, qName, atts);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.initContentHandler();
        this.contentHandler.startPrefixMapping(prefix, uri);
    }
}

