/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.dao.impl;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import uk.ac.cam.caret.sakai.rwiki.model.RWikiPropertyImpl;
import uk.ac.cam.caret.sakai.rwiki.service.api.dao.RWikiPropertyDao;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiProperty;
import uk.ac.cam.caret.sakai.rwiki.utils.TimeLogger;

public class RWikiPropertyDaoImpl
extends HibernateDaoSupport
implements RWikiPropertyDao {
    private static Log log = LogFactory.getLog(RWikiPropertyDaoImpl.class);
    private String schemaVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RWikiProperty getProperty(final String name) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(RWikiProperty.class).add((Criterion)Expression.eq((String)"name", (Object)name)).list();
                }
            };
            List found = (List)this.getHibernateTemplate().execute(callback);
            if (found.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found " + found.size() + " objects with name " + name));
                }
                RWikiProperty rWikiProperty = null;
                return rWikiProperty;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + found.size() + " objects with name " + name + " returning most recent one."));
            }
            RWikiProperty rWikiProperty = (RWikiProperty)found.get(0);
            return rWikiProperty;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("RWikiPropertyDaoImpl.getContentObject: " + name), (long)start, (long)finish);
        }
    }

    public RWikiProperty createProperty() {
        return new RWikiPropertyImpl();
    }

    public void update(RWikiProperty property) {
        this.getHibernateTemplate().saveOrUpdate((Object)property);
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }
}

