/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.macros;

import java.io.IOException;
import java.io.Writer;
import org.radeox.api.macro.MacroParameter;
import org.radeox.macro.BaseMacro;
import uk.ac.cam.caret.sakai.rwiki.component.Messages;

public class BackgroundColorMacro
extends BaseMacro {
    private static final String BACKGROUND_COLOR_PARAM = "bgcolor";

    public String getName() {
        return BACKGROUND_COLOR_PARAM;
    }

    public String[] getParamDescription() {
        return new String[]{Messages.getString("BackgroundColorMacro.1")};
    }

    public String getDescription() {
        return Messages.getString("BackgroundColorMacro.2");
    }

    public void execute(Writer writer, MacroParameter params) throws IllegalArgumentException, IOException {
        writer.write("<span style='");
        String color = params.get(BACKGROUND_COLOR_PARAM);
        if (color == null) {
            color = params.get(0);
        }
        writer.write(this.parse(color, "background: "));
        writer.write("'>");
        if (params.getContent() != null) {
            writer.write(params.getContent());
        }
        writer.write("</span>");
    }

    private String parse(String color, String cssClass) {
        if (color == null) {
            return "";
        }
        char[] disallowedChars = new char[]{':', ';', '/', '*', '{', '}', '\"', '\'', '\\'};
        for (int i = 0; i < disallowedChars.length; ++i) {
            if (color.indexOf(disallowedChars[i]) <= 0) continue;
            throw new IllegalArgumentException(Messages.getString("BackgroundColorMacro.0") + color + Messages.getString("BackgroundColorMacro.10"));
        }
        return cssClass + color + ';';
    }
}

