/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.macros;

import java.io.IOException;
import java.io.Writer;
import org.radeox.api.macro.MacroParameter;
import org.radeox.macro.BaseMacro;
import uk.ac.cam.caret.sakai.rwiki.component.Messages;

public class BlockMacro
extends BaseMacro {
    public String[] getParamDescription() {
        return new String[]{Messages.getString("BlockMacro.0"), Messages.getString("BlockMacro.01"), Messages.getString("BlockMacro.1"), Messages.getString("BlockMacro.2")};
    }

    public String getDescription() {
        return Messages.getString("BlockMacro.3");
    }

    public String getName() {
        return "block";
    }

    public void execute(Writer writer, MacroParameter params) throws IllegalArgumentException, IOException {
        int i;
        int end;
        char[] nameChars;
        String cssClass = params.get("class");
        if (cssClass == null && (cssClass = params.get(0)) != null) {
            if (cssClass.startsWith("id=")) {
                cssClass = null;
            } else if (cssClass.startsWith("name=")) {
                cssClass = null;
            }
        }
        String id = params.get("id");
        String anchorName = params.get("name");
        String style = params.get("style");
        writer.write("<div");
        if (cssClass != null && !"".equals(cssClass)) {
            cssClass = cssClass.replaceAll("[^A-Za-z0-9-_]", "");
            writer.write(" class='");
            writer.write(cssClass);
            writer.write(39);
        }
        if (style == null || !"".equals(style)) {
            // empty if block
        }
        if (id != null && !"".equals(id)) {
            writer.write(" id='");
            nameChars = id.toCharArray();
            end = 0;
            for (i = 0; i < nameChars.length; ++i) {
                if (!Character.isLetterOrDigit(nameChars[i])) continue;
                nameChars[end++] = nameChars[i];
            }
            if (end > 0) {
                writer.write(nameChars, 0, end);
            }
            writer.write(39);
        }
        writer.write(62);
        if (anchorName != null && !"".equals(anchorName)) {
            writer.write("<a name=\"");
            nameChars = anchorName.toCharArray();
            end = 0;
            for (i = 0; i < nameChars.length; ++i) {
                if (!Character.isLetterOrDigit(nameChars[i])) continue;
                nameChars[end++] = nameChars[i];
            }
            if (end > 0) {
                writer.write(nameChars, 0, end);
            }
            writer.write("' class='anchorpoint'>");
            writer.write("<!-- --></a>");
        }
        if (params.getContent() != null) {
            writer.write("<p class=\"paragraph\">");
            writer.write(params.getContent());
            writer.write("</p>");
        }
        writer.write("</div>");
    }
}

