/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.message.dao.impl;

import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import uk.ac.cam.caret.sakai.rwiki.message.model.PreferenceImpl;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.dao.PreferenceDao;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.model.Preference;
import uk.ac.cam.caret.sakai.rwiki.utils.TimeLogger;

public class PreferenceDaoImpl
extends HibernateDaoSupport
implements PreferenceDao {
    private static Log log = LogFactory.getLog(PreferenceDaoImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findByUser(final String user) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(Preference.class).add((Criterion)Expression.eq((String)"userid", (Object)user)).list();
                }
            };
            List list = (List)this.getHibernateTemplate().execute(callback);
            return list;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("PreferenceDaoImpl.findByUserId: " + user), (long)start, (long)finish);
        }
    }

    public Preference createPreference(String user, String prefcontext, String preftype, String preference) {
        PreferenceImpl pref = new PreferenceImpl();
        pref.setLastseen(new Date());
        pref.setPreference(preference);
        pref.setPrefcontext(prefcontext);
        pref.setPreftype(preftype);
        pref.setUserid(user);
        return pref;
    }

    public void update(Object o) {
        this.getHibernateTemplate().saveOrUpdate(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findByUser(final String user, final String context) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    String prefcontext = context + "%";
                    return session.createCriteria(Preference.class).add((Criterion)Expression.eq((String)"userid", (Object)user)).add((Criterion)Expression.like((String)"prefcontext", (Object)prefcontext)).list();
                }
            };
            List list = (List)this.getHibernateTemplate().execute(callback);
            return list;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("PreferenceDaoImpl.findByUser: " + user), (long)start, (long)finish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findByUser(final String user, final String context, final String type) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    String prefcontext = context + "%";
                    return session.createCriteria(Preference.class).add((Criterion)Expression.eq((String)"userid", (Object)user)).add((Criterion)Expression.eq((String)"preftype", (Object)type)).add((Criterion)Expression.like((String)"prefcontext", (Object)prefcontext)).list();
                }
            };
            List list = (List)this.getHibernateTemplate().execute(callback);
            return list;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("PreferenceDaoImpl.findByUser: " + user), (long)start, (long)finish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findExactByUser(final String user, final String context) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(Preference.class).add((Criterion)Expression.eq((String)"userid", (Object)user)).add((Criterion)Expression.eq((String)"prefcontext", (Object)context)).list();
                }
            };
            List list = (List)this.getHibernateTemplate().execute(callback);
            return list;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("PreferenceDaoImpl.findExactByUser: " + user), (long)start, (long)finish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preference findExactByUser(final String user, final String context, final String type) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(Preference.class).add((Criterion)Expression.eq((String)"userid", (Object)user)).add((Criterion)Expression.eq((String)"preftype", (Object)type)).add((Criterion)Expression.eq((String)"prefcontext", (Object)context)).list();
                }
            };
            List found = (List)this.getHibernateTemplate().execute(callback);
            if (found.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found " + found.size() + " objects with name " + user));
                }
                Preference preference = null;
                return preference;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + found.size() + " objects with name " + user + " returning most recent one."));
            }
            Preference preference = (Preference)found.get(0);
            return preference;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("PreferenceDaoImpl.findExactByUser: " + user), (long)start, (long)finish);
        }
    }

    public int delete(String user, String context, String type) {
        List l = this.findByUser(user, context, type);
        int ndel = 0;
        for (Preference p : l) {
            this.delete(p);
            ++ndel;
        }
        return ndel;
    }

    public int deleteExact(String user, String context, String type) {
        Preference p = this.findExactByUser(user, context, type);
        if (p == null) {
            return 0;
        }
        this.delete(p);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(final Preference pref) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    session.delete((Object)pref);
                    return 1;
                }
            };
            int n = (Integer)this.getHibernateTemplate().execute(callback);
            return n;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("PreferenceDaoImpl.delete: " + pref), (long)start, (long)finish);
        }
    }
}

