/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.model.impl;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.cam.caret.sakai.rwiki.service.api.dao.RWikiPropertyDao;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.DataMigrationAgent;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.DataMigrationController;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiProperty;

public class DataMigrationSpecification
implements DataMigrationController {
    private static Log log = LogFactory.getLog(DataMigrationSpecification.class);
    private RWikiProperty targetVersion;
    private List migrationAgents;
    private RWikiPropertyDao propertyDao;
    private boolean performDataMigrations;

    public boolean isPerformDataMigrations() {
        return this.performDataMigrations;
    }

    public void setPerformDataMigrations(boolean performDataMigrations) {
        this.performDataMigrations = performDataMigrations;
    }

    public void update() throws Exception {
        String targetVersionString = this.targetVersion.getValue();
        RWikiProperty currentVersion = this.propertyDao.getProperty(this.targetVersion.getName());
        String currentVersionString = null;
        if (currentVersion != null) {
            currentVersionString = currentVersion.getValue();
        }
        if (currentVersionString != null && currentVersionString.equals(targetVersionString)) {
            log.info((Object)("No data migration performed, target version present " + targetVersionString));
            return;
        }
        if (this.performDataMigrations) {
            boolean newdb = currentVersionString == null;
            for (DataMigrationAgent a : this.migrationAgents) {
                currentVersionString = a.migrate(currentVersionString, targetVersionString, newdb);
            }
            if (currentVersion == null) {
                currentVersion = this.propertyDao.createProperty();
                currentVersion.setName(this.targetVersion.getName());
            }
            currentVersion.setValue(currentVersionString);
            this.propertyDao.update(currentVersion);
            if (currentVersionString != null && currentVersionString.equals(targetVersionString)) {
                log.info((Object)("RWiki Data migrated to version " + currentVersionString + " sucessfuly"));
                return;
            }
        }
        log.fatal((Object)("RWiki Data has NOT been migrated to the current version, you MUST investigate before using the RWiki Tool\n currentVersion: " + currentVersionString + " targetVersion: " + targetVersionString));
        throw new RuntimeException("RWiki Data has NOT been migrated to the current version, you MUST investigate before using the RWiki Tool\n currentVersion: " + currentVersionString + " targetVersion: " + targetVersionString);
    }

    public RWikiPropertyDao getPropertyDao() {
        return this.propertyDao;
    }

    public void setPropertyDao(RWikiPropertyDao propertyDao) {
        this.propertyDao = propertyDao;
    }

    public void setTargetVersion(RWikiProperty targetVersion) {
        this.targetVersion = targetVersion;
    }

    public List getMigrationAgents() {
        return this.migrationAgents;
    }

    public void setMigrationAgents(List migrationAgents) {
        this.migrationAgents = migrationAgents;
    }

    public RWikiProperty getTargetVersion() {
        return this.targetVersion;
    }
}

