/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.macros;

import java.io.IOException;
import java.io.Writer;
import org.radeox.api.macro.MacroParameter;
import org.radeox.macro.BaseMacro;
import org.sakaiproject.site.api.Site;
import uk.ac.cam.caret.sakai.rwiki.component.Messages;
import uk.ac.cam.caret.sakai.rwiki.component.radeox.service.impl.SpecializedRenderContext;
import uk.ac.cam.caret.sakai.rwiki.component.radeox.service.impl.SpecializedRenderEngine;

public class WorksiteInfoMacro
extends BaseMacro {
    private static final String DESCRIPTION = "description";
    private static final String SHORTDESCRIPTION = "shortdescription";
    private static final String WIKISPACE = "wikispace";

    public String[] getParamDescription() {
        return new String[]{Messages.getString("WorksiteInfoMacro.3") + Messages.getString("WorksiteInfoMacro.4") + Messages.getString("WorksiteInfoMacro.5") + Messages.getString("WorksiteInfoMacro.6"), Messages.getString("WorksiteInfoMacro.7")};
    }

    public String getDescription() {
        return Messages.getString("WorksiteInfoMacro.8");
    }

    public String getName() {
        return "worksiteinfo";
    }

    public void execute(Writer writer, MacroParameter params) throws IllegalArgumentException, IOException {
        SpecializedRenderContext context = (SpecializedRenderContext)params.getContext();
        SpecializedRenderEngine spRe = (SpecializedRenderEngine)context.getRenderEngine();
        String infotype = params.get("info", 0);
        Site s = context.getSite();
        if (s != null) {
            if (DESCRIPTION.equals(infotype)) {
                String desc = s.getDescription();
                if (desc == null) {
                    desc = "";
                }
                writer.write(desc);
            } else if (SHORTDESCRIPTION.equals(infotype)) {
                String desc = s.getShortDescription();
                if (desc == null) {
                    desc = "";
                }
                writer.write(desc);
            } else if (WIKISPACE.equals(infotype)) {
                String desc = spRe.getSpace();
                if (desc == null) {
                    desc = "";
                }
                writer.write(desc);
            } else {
                String desc = s.getTitle();
                if (desc == null) {
                    desc = "";
                }
                writer.write(desc);
            }
        } else {
            writer.write(Messages.getString("WorksiteInfoMacro.11"));
        }
    }
}

