/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.model.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.dv.util.Base64;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.util.BaseResourceProperties;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiEntity;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.utils.NameHelper;

public class RWikiEntityImpl
implements RWikiEntity {
    private static Log log = LogFactory.getLog(RWikiEntityImpl.class);
    public static final String RW_ID = "id";
    private RWikiObject rwo = null;
    private Reference reference = null;

    public RWikiEntityImpl(RWikiObject rwo) {
        this.rwo = rwo;
    }

    public RWikiEntityImpl(Reference ref) {
        this.reference = ref;
    }

    public ResourceProperties getProperties() {
        if (this.rwo == null) {
            BaseResourceProperties rp = new BaseResourceProperties();
            rp.addProperty("realm", this.reference.getContext() + this.reference.getContainer());
            rp.addProperty("realm", this.reference.getId());
            rp.addProperty("container", "true");
            return rp;
        }
        BaseResourceProperties rp = new BaseResourceProperties();
        rp.addProperty(RW_ID, this.getId());
        rp.addProperty("name", this.rwo.getName());
        rp.addProperty("owner", this.rwo.getOwner());
        rp.addProperty("realm", this.rwo.getRealm());
        rp.addProperty("referenced", this.rwo.getReferenced());
        rp.addProperty("rwid", this.rwo.getRwikiobjectid());
        rp.addProperty("sha1", this.rwo.getSha1());
        rp.addProperty("user", this.rwo.getUser());
        rp.addProperty("group-admin", String.valueOf(this.rwo.getGroupAdmin()));
        rp.addProperty("group-read", String.valueOf(this.rwo.getGroupRead()));
        rp.addProperty("group-write", String.valueOf(this.rwo.getGroupWrite()));
        rp.addProperty("owner-admin", String.valueOf(this.rwo.getOwnerAdmin()));
        rp.addProperty("owner-read", String.valueOf(this.rwo.getOwnerRead()));
        rp.addProperty("owner-write", String.valueOf(this.rwo.getOwnerWrite()));
        rp.addProperty("public-read", String.valueOf(this.rwo.getPublicRead()));
        rp.addProperty("public-write", String.valueOf(this.rwo.getPublicWrite()));
        rp.addProperty("revision", String.valueOf(this.rwo.getRevision()));
        rp.addProperty("version", String.valueOf(this.rwo.getVersion().getTime()));
        rp.addProperty("container", "false");
        return rp;
    }

    public String getReference() {
        if (this.rwo == null) {
            return "/wiki" + this.reference.getId() + ".";
        }
        return "/wiki" + this.rwo.getName() + ".";
    }

    public String getUrl() {
        if (this.rwo == null) {
            return "/wiki" + this.encode(this.reference.getId()) + ".";
        }
        return "/wiki" + this.encode(this.rwo.getName()) + ".";
    }

    private String encode(String toEncode) {
        try {
            String encoded = URLEncoder.encode(toEncode, "UTF-8");
            encoded = encoded.replaceAll("\\+", "%20").replaceAll("%2F", "/");
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 Encoding is not supported when encoding: " + toEncode + ": " + e.getMessage());
        }
    }

    public Element toXml(Document doc, Stack stack) {
        if (this.rwo == null) {
            throw new RuntimeException(" Cant serialise containers at the moment ");
        }
        Element wikipage = doc.createElement("wikipage");
        if (stack.isEmpty()) {
            doc.appendChild(wikipage);
        } else {
            ((Element)stack.peek()).appendChild(wikipage);
        }
        stack.push(wikipage);
        wikipage.setAttribute("eid", this.rwo.getId());
        wikipage.setAttribute("page-name", this.rwo.getName());
        wikipage.setAttribute("revision", String.valueOf(this.rwo.getRevision()));
        wikipage.setAttribute("last-edited-by", this.rwo.getUser());
        wikipage.setAttribute("owner", this.rwo.getOwner());
        this.getProperties().toXml(doc, stack);
        Element content = doc.createElement("wikicontent");
        stack.push(content);
        wikipage.appendChild(content);
        content.setAttribute("enc", "BASE64");
        try {
            String b64Content = Base64.encode((byte[])this.rwo.getContent().getBytes("UTF-8"));
            CDATASection t = doc.createCDATASection(b64Content);
            stack.push(t);
            content.appendChild(t);
            stack.pop();
        }
        catch (UnsupportedEncodingException usex) {
            throw new IllegalStateException("Cannot find Encoding UTF-8");
        }
        stack.pop();
        stack.pop();
        return wikipage;
    }

    public void fromXml(Element el, String defaultRealm) throws Exception {
        if (this.rwo == null) {
            throw new RuntimeException(" Cant deserialise containers at the moment ");
        }
        NodeList nl = el.getElementsByTagName("properties");
        if (nl == null || nl.getLength() != 1) {
            throw new Exception("Cant find a properties element in " + el.getNodeName() + " id: " + el.getAttribute("eid") + " pagename: " + el.getAttribute("page-name"));
        }
        Element properties = (Element)nl.item(0);
        BaseResourceProperties rp = new BaseResourceProperties(properties);
        nl = el.getElementsByTagName("wikicontent");
        if (nl == null || nl.getLength() != 1) {
            throw new Exception("Cant find a  wikiproperties element in " + el.getNodeName() + " id: " + el.getAttribute("eid") + " pagename: " + el.getAttribute("page-name"));
        }
        Element wikiContents = (Element)nl.item(0);
        nl = wikiContents.getChildNodes();
        StringBuffer content = new StringBuffer();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof CharacterData)) continue;
            CharacterData cdnode = (CharacterData)n;
            try {
                content.append(new String(Base64.decode((String)cdnode.getData()), "UTF-8"));
                continue;
            }
            catch (Throwable t) {
                log.warn((Object)("Cant decode node content for " + cdnode));
            }
        }
        String realm = rp.getProperty("realm");
        this.rwo.setId(rp.getProperty(RW_ID));
        this.rwo.setName(NameHelper.globaliseName((String)NameHelper.localizeName((String)rp.getProperty("name"), (String)realm), (String)defaultRealm));
        this.rwo.setOwner(rp.getProperty("owner"));
        this.rwo.setRealm(defaultRealm);
        this.rwo.setReferenced(rp.getProperty("referenced"));
        this.rwo.setContent(content.toString());
        if (!this.rwo.getSha1().equals(rp.getProperty("sha1"))) {
            throw new Exception("Sha Checksum Missmatch on content " + rp.getProperty("sha1") + " != " + this.rwo.getSha1());
        }
        this.rwo.setUser(rp.getProperty("user"));
        this.rwo.setGroupAdmin(rp.getBooleanProperty("group-admin"));
        this.rwo.setGroupRead(rp.getBooleanProperty("group-read"));
        this.rwo.setGroupWrite(rp.getBooleanProperty("group-write"));
        this.rwo.setOwnerAdmin(rp.getBooleanProperty("owner-admin"));
        this.rwo.setOwnerRead(rp.getBooleanProperty("owner-read"));
        this.rwo.setOwnerWrite(rp.getBooleanProperty("owner-write"));
        this.rwo.setPublicRead(rp.getBooleanProperty("public-read"));
        this.rwo.setPublicWrite(rp.getBooleanProperty("public-write"));
        this.rwo.setRevision(Integer.valueOf(rp.getProperty("revision")));
        this.rwo.setVersion(new Date(rp.getLongProperty("version")));
    }

    public String getReference(String rootProperty) {
        return this.getReference();
    }

    public String getUrl(String rootProperty) {
        return this.getUrl();
    }

    public String getId() {
        if (this.rwo == null) {
            return this.reference.getId();
        }
        return this.rwo.getId();
    }

    public RWikiObject getRWikiObject() {
        if (this.rwo == null) {
            throw new RuntimeException("RWiki Containers dont have objects attached ");
        }
        return this.rwo;
    }

    public boolean isContainer() {
        return this.rwo == null;
    }
}

